% Independent Modified Hooke Jeeves optimisation algorithm
tic_flag=0;

dVar=d1; % variable variation 
fob(2*nVar+1)=0;                % allocate fob vector 
fob(1)=t_cost;     % objective function
dnf(nVar)=0;                     % allocate dnf vector  
dpf(nVar)=0;                     % allocate dpf vector 
i_trace=1;
opt_trace=[Var0,fob(1),eval(output)];
sdf=1;
while sdf>0
   for i_var=1:nVar     % evaluate objective function in 2*nVar direction
       Varo=Var0;
       if(Varo(i_var)<Var_up(i_var))
            Varo(i_var)=Var0(i_var)+dVar(i_var);
            iup=find(Varo>Var_up);
            Varo(iup)=Var_up(iup);
            case_eval;
            fob(2*i_var)=t_cost;
            sr_trace(2*i_var,:)=eval(output);
       else
           fob(2*i_var)=fob(1);
       end
       dpf(i_var)=fob(1)-fob(2*i_var);
       Varo=Var0;
       if(Varo(i_var)>Var_low(i_var))
            Varo(i_var)=Var0(i_var)-dVar(i_var);
            ilow=find(Varo<Var_low);
            Varo(ilow)=Var_low(ilow);
            case_eval;
            fob(2*i_var+1)=t_cost;
            sr_trace(2*i_var+1,:)=eval(output);
       else
           fob(2*i_var+1)=fob(1);
       end
       dnf(i_var)=fob(1)-fob(2*i_var+1);
    end
    df=max(dpf,dnf); % chose the maximum variation of obj. func. 
    df=max(df,0);       % keep the element of obj. func. variation at minimum zero level
    sdf=sum(df);        % sum of partial derivative obj. func =0 are stopping the search  
    if sdf>0
        sdV=ones(size(df));
        in=find(df==dnf); % find the negative variation which produces desired obj. func. 
        sdV(in)=-1;
        dVar2=sdV.*(df~=0).*max(df.*dVar/norm(df),d2);%through direction in the optimization variable space 
        [dfm, im]=max(df);
        Vars=Var0;
        Vars(im)=min(max(Var0(im)+sdV(im)*dVar(im),Var_low(im)),Var_up(im)); % a better value of optimization variable set
        imm=2*im+(1-sdV(im))/2;
        fobmin=fob(imm);
        i_trace=i_trace+1;
        opt_trace(i_trace,:)=[Vars,fobmin,sr_trace(imm,:)];
        %fobmin=fob(1)-dfm; %minimum obj. func. for optimization search in the through
        Var0(im)=Vars(im); fob(1)=fobmin; %increase the algorithm speed
        %but reduce also probability to find minimum
       
        ds=1
        while ds==1         % search loop in the through direction
           Varo=Var0+dVar2;
           ilow=find(Varo<Var_low);
           Varo(ilow)=Var_low(ilow);
           iup=find(Varo>Var_up);
           Varo(iup)=Var_up(iup);
           case_eval;
           fob2=t_cost;   
           if(fob2<fobmin)
              fobmin=fob2
              fob(1)=fob2;
              Vars=Varo;
              i_trace=i_trace+1;
                  opt_trace(i_trace,:)=[Varo,fob(1),eval(output)];
            else
               ds=0; %the obj. func. through direction is changed 
            end
            Var0=Vars;
        end
        fob(1)=fobmin;
     else
        if(any(dVar>d2))
                dVar=max(dVar/ropt,d2); % update the variable variation step
            sdf=1; %let the main loop to continue objective search with small step 
        end
     end
end
%Run again the best solution
show_fig=1;
Varst=opt_trace(end,1:nVar);
Varo=Varst;
case_eval;
t1=toc