fid=fopen(output_file,'w');
fprintf(fid,'Pn=%f;     %% W - rated power \n', Pn);
fprintf(fid,'fn=%f;     %% Hz - base speed\n', fn);
fprintf(fid,'Vfn=%f;     %% V - rated voltage\n', Vfn);
fprintf(fid,'pp=%d;     %% numbers of poles\n\n', pp);
 
fprintf(fid,'\n%% Electrical parameters \n');
 
fprintf(fid,'Rs=%f; %% Ohm - main phase resistance at Tw=%f \n', Rs,Tw1);
%{ 
fprintf(fid,'Lss=%f;    %% H - slot leakage inductance -analytical\n', Lss);
fprintf(fid,'Lsec=%f;   %% H - end connection leakage inductance - analitica\n',Lsec);
fprintf(fid,'Lsm=%f;    %% H - main inductance  analytical \n', Lsm);
fprintf(fid,'Ls_an=%f;  %% H - stator inductance - analytical\n', Ls_an);
%fprintf(fid,'Ld=%f;    %% H - d axis inductance\n', Ld);
fprintf(fid,'Lq_fem=%f; %% H - q axis inductance without end connections at Iq= %f A\n', Lq_fem,Ian);
fprintf(fid,'Lq=%f;     %% H - q axis inductance at Iq= %f A\n', Lq,Ian);
%}
fprintf(fid,'N1=%f;     %%  - turns on main winding \n',N1);
fprintf(fid,'psipm0=%f; %% Wb - permanent magnet linkage flux\n', psipm0);
 
fprintf(fid,'\n%% Test point results\n');
fprintf(fid,'Tp1=%f;      %%Nm - test torque \n',Tp1);
fprintf(fid,'n1=%f;    %% rpm -test speed \n',n1);
fprintf(fid,'P1=%f;   %%W test power\n',P1);
fprintf(fid,'Ip1=%f;    %% A  - phase current at test point (rms) \n', Ip1);
fprintf(fid,'Pcup1=%f;   %% W  - copper losses \n',Pcup1);
fprintf(fid,'Pfe1=%f;   %% W  - iron losses \n',Pfe1);
fprintf(fid,'eta1=%f;  %%   - test point efficiency \n',eta1);
%fprintf(fid,'cosphin1=%f;  %%   - test point power factor \n',cosphin1);
 
fprintf(fid,'\n%% Base speed results\n');
fprintf(fid,'Tn=%f;    %% Nm  - rated torque\n',Tn);
fprintf(fid,'In=%f;    %% A  - phase rated current (rms)\n', In);
%fprintf(fid,'Ien=%f;    %% A  - torque q axis current (rms) \n', Ien);
%fprintf(fid,'Vepm=%f;   %% V (rms) - phase pm emf at rated speed \n', Vepm);
fprintf(fid,'Pcun=%f;   %% W  - copper losses \n',Pcun);
fprintf(fid,'Pfen=%f;   %% W  - iron losses \n',Pfen);
fprintf(fid,'etan=%f;  %%   - rated efficiency \n',etan);
fprintf(fid,'cosphin=%f; %% - rated power factor \n',cosphin);
%{ 
fprintf(fid,'\n%% Maximum speed results\n');
fprintf(fid,'Inmax=%f;    %% A  - phase rated current (rms)\n', abs(Inmax));
fprintf(fid,'Idnmax=%f;    %% A  - rated d axis current (peak) \n', Idnmax);
fprintf(fid,'Iqnmax=%f;    %% A  - rated q axis current (peak) \n', Iqnmax);
fprintf(fid,'Pcunmax=%f;   %% W  - copper losses \n',Pcunmax);
fprintf(fid,'Pfenmax=%f;   %% W  - iron losses \n',Pfenmax);
fprintf(fid,'etanmax=%f;  %%   - ratedd efficiency \n',etanmax);
fprintf(fid,'cosphinmax=%f; %% - rated power factor \n',cosphinmax);
%fprintf(fid,'Bmag1=%f;  %% T - ideal (no load) air gap flux density \n',Bmag1); 
%}  
fprintf(fid,'\n%% Constructive dimensions \n');
 
fprintf(fid,'Dso=%f;    %%mm - stator outer diameter \n',Dso);
fprintf(fid,'lstack=%f;    %%mm - motor axial length \n',lstack);
fprintf(fid,'Rso=%f;    %%mm - stator outer Radious \n',Rso);
fprintf(fid,'Rsi=%f;    %%mm - stator inner Radious \n',Rsi);
fprintf(fid,'Dri=%f;    %% mm Rotor inner (shaft) diameter \n',Dri_min);
fprintf(fid,'hpm=%f;    %% mm PM height \n',hpm);
%fprintf(fid,'lpm_pu=%f; %% width of PM relative to the rotor diameter \n',lpm_pu);
fprintf(fid,'hry=%f;    %% mm rotor yoke height \n',hry);
fprintf(fid,'\n%% Stator slots dimensions\n');
fprintf(fid,'sMs=%f;    %% mm - stator slots opening \n',sMs);
fprintf(fid,'hs4=%f;    %% mm - height of stator tooth tip \n',hs4); 
fprintf(fid,'hs3=%f;    %% mm - wedge height  \n',hs3);
fprintf(fid,'swi=%f;    %% mm slot small base width \n',wsi);
fprintf(fid,'swo=%f;    %% mm slot large base width \n',wso);
fprintf(fid,'shl=%f;    %% mm slot height - main part \n',hs1);
fprintf(fid,'sht=%f;    %% mm total slot height\n',hs);
fprintf(fid,'hsy=%f;    %% mm stator yoke height \n',hsy);
fprintf(fid,'wtooth=%f; %% mm stator tooth width \n',wtooth);
%fprintf(fid,'sh=%f;     %% mm stator total height \n',sh);
%fprintf(fid,'rh=%f;     %% mm rotor total height \n',lpm+hry);
 
fprintf(fid,'\n%% Windings details\n');
fprintf(fid,'N1=%d;    %% turns per phase \n',N1);
fprintf(fid,'q1=%d;    %% coils per phase \n',q1);
fprintf(fid,'sb=%d;    %% turns per coil \n',sb);
fprintf(fid,'dco=%f;    %% mm - diameter of winding wire \n',dco);
  
fprintf(fid,'\n%% Weights\n');
fprintf(fid,'mcu=%f;     %% kg - copper mass \n', mcu);
fprintf(fid,'mpm=%f;     %% kg - permanent magnet mass \n', mpm);
fprintf(fid,'msteeth=%f; %% kg - stator teeth mass \n', msteeth);
fprintf(fid,'msyoke=%f; %% kg - stator yoke mass \n', msyoke);
fprintf(fid,'msiron=%f; %% kg - stator iron mass \n', msiron);
fprintf(fid,'mriron=%f; %% kg - rotor iron mass \n', mriron);
%fprintf(fid,'mst=%f;     %% kg - stator mass \n', mst);
%fprintf(fid,'mrt=%f;     %% kg - rotor mass \n', mrt);
fprintf(fid,'mmot=%f;    %% kg - motor mass \n', mmot);
fprintf(fid,'mVol=%f;    %% liter - motor volume (without end connections) \n', mVol);
fprintf(fid,'Tn2m=%f;    %% Nm/kg - torque mass density \n', Tn2m);
fprintf(fid,'Tn2mVol=%f; %% Nm/liter - torque volume density \n', Tn2mVol);
%fprintf(fid,'Jr=%f;      %% kg*m^2 - rotor Inertia \n', Jr);
 
fprintf(fid,'\n%% Objective function\n');
fprintf(fid,'cu_c=%f;   %% USD - copper cost\n',cu_c);
fprintf(fid,'lam_c=%f;  %% USD - lamination cost \n',lam_c);
fprintf(fid,'PM_c=%f;   %% USD - PM cost \n', PM_c);
fprintf(fid,'pmw_c=%f;  %% USD - weight penalty cost (frame) \n',pmw_c);
fprintf(fid,'mot_cost=%f;   %% USD - motor cost \n',mot_cost);
fprintf(fid,'t_sim=[%f %f %f];   %%s - FEM computation time \n',t_sim);
    
fprintf(fid,'\n\n %% -------------------------------------------------------------------------------\n');
fprintf(fid,'\n\n\t %%This outputs was produced using the next data as input:\n');
fid2=fopen([f_input,'.m'],'r');
while 1
    [line,lt]=fgets(fid2);
    %if ~isstr(line), break, end
    if ~ischar(line), break, end
    fprintf(fid,'%s',line);
end
fclose(fid2);
 
fprintf(fid,'\n%%------------------------------------------------------------------------\n');
  
fclose(fid);

