% Setting the material

%Setting the stator core material
eval(stcore_mat);
error_status=0;
if(exist('nfem','var'))
    stcore_fem=nfem;
    clear nfem;
else
    stcore_fem=0;
end
rho_ironst=rho_iron;
BHs_ref=[Bref;Href];  

%Setting the rotor core material
if(exist('rtcore_mat','var'))
    eval(rtcore_mat);
    stcore_fem=nfem;
    clear nfem;
else
    rtcore_mat=stcore_mat;
    rtcore_fem=stcore_fem;
end
BHr_ref=[Bref;Href]; 

%Setting the shaft material if it is considered as magnetic path

eval(shaft_mat);
if(exist('nfem','var'))
   shaft_fem=nfem;
   clear nfem;
else
    shaft_fem=0;
end
BHsh_ref=[Bref;Href];

eval(pm_material);
Hc=Hc_20*(1+(Tpm-20)*Tcbr1/100); % computing the PMM coercitive field at working temperature
if(Tpm<2)
    Br=Br_20*(1+Tcbr1*(Tpm-20)/100);
else
    Br=Br_20*(1+Tcbr2*(Tpm-20)/100);
end
mu_pm=Br/Hc;    %PM permeability at working temperature
rho1=rho_copper*(1+alpha_copper*Tw1)/(1+20*alpha_copper);   % stator winding resistivity
