openfemm;
newdocument(2); %2- thermal

%define problem parameters
hi_probdef('millimeters','planar',1e-8,lstack,25);

%add materials
    %hi_addmaterial("materialname", kx, ky, qv, kt) adds a new material
    %kx,ky -Thermal conductivity in the x (r), y (z) -direction.
    %qv Volume heat generation density in units of W/m3
    %kt Volumetric heat capacity in units of MJ/(m3*K).

hi_addmaterial('yoke',Fetcond,Fetcond,core_qv,Fesheat);
%hi_addmaterial('teeth',Fetcond,Fetcond,0,Fesheat);
hi_addmaterial('rotor',Fetcond,Fetcond,0,Fesheat);
hi_addmaterial('frame',frameCond,frameCond,0,frameHeat);
hi_addmaterial('PM',PMtcond,PMtcond,0,PMsheat);
hi_addmaterial('coil',coil_k,coil_k,coil_qv,coil_ht);
%hi_getmaterial('Copper, Pure');
hi_getmaterial('Air');
hi_modifymaterial('Air',4,0.00121) %MJ/m^3/K corection of Air heat capacity

%add boundary conditions
hi_addboundprop('Outer Boundary',2,0,0,Tamb+TCK,alpha_t*kv,0);
hi_addboundprop('Inner Boundary',2,0,0,Tamb+TCK,alpha_t*kv,0);

if(simrange>0)
    alpha_p1=2*pi*simrange/poles;
    xf=[Rri Rpmi Rpmo Rro Rsi Rso];
else
    xf=[Rri Rro Rsi Rso]; % costruction without rotor internal structure
end
n_bound=length(xf);
%draw the geometry

yf=zeros(size(xf));
xf2=xf*cos(alpha_p1);
yf2=xf*sin(alpha_p1);

c_alphap1=cos(alpha_p1/2);
s_alphap1=sin(alpha_p1/2);
xgf=xf(1:n_bound-1)+diff(xf)/2;
xgf2=xf2(1:n_bound-1)+diff(xf2)/2;
ygf2=yf2(1:n_bound-1)+diff(yf2)/2;

if(poles~=poles1)
    hi_drawpolyline([xf',yf']);
    hi_drawpolyline([xf2',yf2']);
   

    hi_addarc(xf(1),yf(1),xf2(1),yf2(1),360/poles*poles1,1);
    %hi_addarc(xf(n_bound-3),yf(n_bound-3),xf2(n_bound-3),yf2(n_bound-3),360/poles*poles1,1);
    hi_addarc(xf(n_bound-2),yf(n_bound-2),xf2(n_bound-2),yf2(n_bound-2),360/poles*poles1,1);
    hi_addarc(xf(n_bound),yf(n_bound),xf2(n_bound),yf2(n_bound),360/poles*poles1,1);
    hi_selectarcsegment(xf(1)*c_alphap1,xf(1)*s_alphap1);
    
    %Boundary condition
    hi_setarcsegmentprop(2,'Inner Boundary',0,1,'none');
    hi_clearselected
    if(hframe<=0) %set boundary condition if is not frame
        hi_selectarcsegment(xf(n_bound)*c_alphap1,xf(n_bound)*s_alphap1);
        hi_setarcsegmentprop(2,'Outer Boundary',0,1,'none');
        hi_clearselected
    end

else
    mi_addnode(xf(n_bound-1),0);
    for istep=0:6
       if(istep==0 || istep==2 || istep==3 || istep==6)
            hi_drawarc(xf(n_bound-istep),0,-xf(n_bound-istep),0,180,1);
            hi_addarc(-xf(n_bound-istep),0,xf(n_bound-istep),0,180,1);
            hi_selectarcsegment(0,xf(n_bound-istep));
            hi_selectarcsegment(0,-xf(n_bound-istep));
            if(istep)
                mi_setarcsegmentprop(2,'none',0,1,'none');
            else
                 mi_setarcsegmentprop(5,'Inner Boundary',0,0,'none');
            end
            mi_clearselected;
        end
    end
end

% Rotor geometry
ypm=bhpm/2*[-1 -1 1 1];
xgpm(poles1+1)=0;ygpm(poles1+1)=0;
xpm=sqrt([Rpmi^2 Rpmo^2 Rpmo^2 Rpmi^2]-bhpm^2/4);
hi_drawline(xpm(3),ypm(3),xpm(4),ypm(4));
hi_addarc(Rpmo,0,xpm(3),ypm(3),atand(ypm(3)/Rpmo),2);
hi_addarc(Rpmi,0,xpm(4),ypm(4),atand(ypm(4)/Rpmi),2);
xpmc=xpm*cos(alphap)-ypm*sin(alphap);
ypmc=xpm*sin(alphap)+ypm*cos(alphap);
wrp1=sqrt((xpm(4)-xpmc(1))^2+(ypm(4)-ypmc(1))^2);

for istep=1:poles1
    hi_drawline(xpmc(1),ypmc(1),xpmc(2),ypmc(2));
    if(istep<poles1)
        hi_drawline(xpmc(3),ypmc(3),xpmc(4),ypmc(4));
        hi_addarc(xpmc(2),ypmc(2),xpmc(3),ypmc(3),2*atand(ypm(3)/Rpmo),2);
        hi_addarc(xpmc(1),ypmc(1),xpmc(4),ypmc(4),2*atand(ypm(4)/Rpmi),2);
        ii1=istep+1;
        xgpm(ii1)=mean(xpmc);
        ygpm(ii1)=mean(ypmc);
        xpmc=xpm*cos(ii1*alphap)-ypm*sin(ii1*alphap);
        ypmc=xpm*sin(ii1*alphap)+ypm*cos(ii1*alphap);
     else
        hi_addarc(xpmc(2),ypmc(2),xf2(3),yf2(3),atand(ypm(3)/Rpmo),2);
        hi_addarc(xpmc(1),ypmc(1),xf2(2),yf2(2),atand(ypm(4)/Rpmi),2);
        xgpm(poles1+1)=(xpmc(1)+xpmc(2)+xf2(3)+xf2(3))/4;
        ygpm(poles1+1)=(ypmc(1)+ypmc(2)+yf2(3)+yf2(3))/4;
    end
    if(wrp1/2*cos(pi/poles)>hrb2max)
        if(istep==1)
            xrb(1:2)=xpm(1)-hrb2*sin(pi/poles)+[0 hrbarrier*cos(pi/poles)];
            yrb(1:2)=bhpm/2+hrb2+[0 0];
            xrb(3:4)=fliplr(xrb(1:2)*cos(alphap)+yrb(1:2)*sin(alphap));
            yrb(3:4)=fliplr(xrb(1:2)*sin(alphap)-yrb(1:2)*cos(alphap));
        else
            xrb1=xrb;
            xrb=xrb*cos(alphap)-yrb*sin(alphap);
            yrb=xrb1*sin(alphap)+yrb*cos(alphap);
        end
        hi_drawpolygon([xrb' yrb']);
        xbl=mean(xrb);
        ybl=mean(yrb);
        hi_addblocklabel(xbl,ybl); % Airgap
        hi_selectlabel(xbl,ybl);
        hi_setblockprop('Air',1,hpm/2,2)
        hi_clearselected;
    end
end

%The rotor Material settings
%hi_setblockprop("blockname", automesh, meshsize, group)
xgpm(1)=(Rpmi+Rpmo+xpm(3)+xpm(4))/4;
ygpm(1)=(ypm(3)+ypm(4))/4;

for istep=1:poles1+1
    hi_addblocklabel(xgpm(istep),ygpm(istep)); %Permanent Magnet
    hi_selectlabel(xgpm(istep),ygpm(istep));
    hi_setblockprop('PM',1,hpm/3,2);
    hi_clearselected;
end

%{
xbl=xgf(1)*c_alphap1;
ybl=xgf(1)*s_alphap1;
hi_addblocklabel(xbl,ybl); %shaft
hi_selectlabel(xbl,ybl);
hi_setblockprop(shaft_fem,1,0.5,'none',0,1,0)
hi_clearselected;
%}

x0rc=(Rri+hry/2)*c_alphap1;
y0rc=(Rri+hry/2)*s_alphap1;
hi_addblocklabel(x0rc,y0rc); % Rotor yoke
hi_selectlabel(x0rc,y0rc);
hi_setblockprop('rotor',1,hpm/2,2)
hi_clearselected;

%The airgap Material settings
xbl=xgf(n_bound-2)*c_alphap1;
ybl=xgf(n_bound-2)*s_alphap1;
hi_addblocklabel(xbl,ybl); % Airgap
hi_selectlabel(xbl,ybl);
hi_setblockprop('Air',1,0.5,1)
hi_clearselected;


% stator geometry
  
xs1=xs0+[0 hs4 hs4+hs3 hs hs hs4+hs3 hs4 0]; %horizontal slot x coordinates
ys1=[-sMs -sMs -wsi -wso wso wsi sMs sMs]/2; % vertical slot y coordinates

    nps=length(xs1);  %number of point per slot
ns1=3*q1*poles1; % number of slots simulated
alphassd=360*atan(sMs/Dsi)/pi; %degree - slot oppening angle
xsp=xf(n_bound-1);
ysp=yf(n_bound-1);
alphastd1=180/Nss-alphassd/2;
alphastd=alphastd1;
for istep=1:ns1
    sina=sin((2*istep-1)*alphas);
    cosa=cos((2*istep-1)*alphas);
    xs=xs1*cosa-ys1*sina;
    ys=xs1*sina+ys1*cosa;
    hi_drawpolyline([xs',ys']);
    hi_addarc(xsp,ysp,xs(1),ys(1),alphastd,2);
    %mi_addarc(xs(1),ys(1),xs(nps),ys(nps),alphassd,2);
    hi_addsegment(xs(3),ys(3),xs(nps-2),ys(nps-2));
    xsp=xs(nps);
    ysp=ys(nps);
    alphastd=2*alphastd1;
%{    
    xbl=(Dsi+sMs)/2*cosa;
    ybl=(Dsi+sMs)/2*sina;
    mi_addblocklabel(xbl,ybl); % Stator oppening
    mi_selectlabel(xbl,ybl);
    mi_setblockprop('Air',1,0.5,'none',0,0,0)
    mi_clearselected;
%}    
    xbl=(Dsi+hs)/2*cosa;
    ybl=(Dsi+hs)/2*sina;
    hi_addblocklabel(xbl,ybl); % Stator slot
    hi_selectlabel(xbl,ybl);
    hi_setblockprop('coil',1,0.5,1)
    hi_clearselected;
end
hi_addarc(xsp,ysp,xf2(n_bound-1),yf2(n_bound-1),alphastd1,2);

xbl=(Dso-hsy)/2*c_alphap1;
ybl=(Dso-hsy)/2*s_alphap1;
hi_addblocklabel(xbl,ybl); % Stator yoke
hi_selectlabel(xbl,ybl);
hi_setblockprop('yoke',1,0.5,1);
hi_clearselected;

if(hframe>0)
    add_frame(Nblades,hblade, gblade, poles, poles1,Rso,hframe)
    xframe=(Rso+hframe/10)*c_alphap1; %point close to iron core
    yframe=(Rso+hframe/10)*s_alphap1;
end

%intrest points coordinate
xcu=(Rsi+hs4+hs3+hs1/2)*cos(alphas);
ycu=(Rsi+hs4+hs3+hs1/2)*sin(alphas);
xfe=(Rsi+hs4+hs3)*cos(2*alphas);
yfe=(Rsi+hs4+hs3)*sin(2*alphas);

switch(analysesType)
    case 's'
        hi_saveas([fem_file,'.feh']);
        hi_analyze(0);
        hi_loadsolution()
        istep=-1;
        getTemp
        
    case 't'
        %create initial condition
        hi_modifymaterial('coil',3,0)
        hi_modifymaterial('yoke',3,0)
        hi_saveas([fem_file,'_0.feh']);
        hi_analyze(0);
        hi_loadsolution()
        
        % transient
        hi_modifymaterial('coil',3,coil_qv)
        hi_modifymaterial('yoke',3,core_qv)
        
        thermalTransient
    case 'c'
        hi_saveas([fem_file,'_0.feh']);
        hi_analyze(0);
        hi_loadsolution()
        
        hi_modifymaterial('coil',3,0)
        hi_modifymaterial('yoke',3,0)
        
        thermalTransient
        
     case 'c0'
        hi_saveas([fem_file,'_0.feh']);
        hi_analyze(0);
        hi_loadsolution()
        
        hi_modifymaterial('coil',3,0)
        hi_modifymaterial('yoke',3,0)
        hi_modifyboundprop('Outer Boundary',5,alpha_t)
        hi_modifyboundprop('Inner Boundary',5,alpha_t)
        
        thermalTransient
end

