%	filename  DK66_65.m
%
%	Properties of DK66 silicon sheet
%	lamination steel. This type of
%	steel is fully processed, and
%	enamelled.
%

%	Ewen Ritchie 98-10-25
%	Copyright (c) 1998 by Ewen Ritchie
%	Inst. of Energy Technology
%	Aalborg University
%	Last modified 98-11-07


%	Global Constants
global	rho_iron iron_density kh fHysExp BHysExp fEddyExp...
			lamThick lamThkExp BEddyExp

Bmax=2;	% 98-11-07


lamThick=0.65;	% Lamination thickness mm
sf = 0.93;	%stacking factor
iron_density = 7.8e3;	% kg/m^3
rho_iron = 61.9e-9;	% ohm/m at 20 deg. C
alpha_iron = 1/1e10;	% 

%------------BH curve----------------------------------------

B=0:Bmax/11:Bmax;	% 98-11-07

%	98-11-07
%	These H-values originate from a TT-lab test
%	from 1969.
%	I am not sure about the value of Bmax=2

HCore=100*[0 0.34 0.45 0.70 2.20 4.50 7.80 14.0 22.5 38.0 68.0 115.];
HTooth=100*[0 1.30 1.70 2.32 3.40 5.00 8.60 16.0 26.0 44.0 76.0 130.];

%------------Iron Loss----------------------------------------
%	For hysteresis loss
kh = 1.0;		% Multiplier constant
fHysExp=1.1;	% frequency exponent
BHysExp=1.8;	% induction exponent

%	For eddy current loss
fEddyExp=2;		% frequency exponent 
BEddyExp=2;		% induction exponent 
lamThkExp=2;	% lamination thickness exponent

%---------------Conversions-------------------------------------
lamThick=lamThick/1000;	% mm to metres