%	Matlab function 'makeIronLoss.m'
%
%	This is a function to calculate the iron loss
%	in a three phase induction machine.
%
%	USES: a material file e.g. DK66.m
%	
%	Ewen Ritchie						98-11-09
%	Aalborg University, Institute of Energy Technology
%	Last modified 98-11-09

function [Piron, Physt, Peddyst] = IronLoss(Bin,f)

%	Global Constants
global	rho_iron iron_density kh fHysExp BHysExp fEddyExp...
			lamThick lamThkExp BEddyExp

% CBR's version of iron loss model

Physt=kh*(1/iron_density)*(f^fHysExp)*(Bin.^BHysExp);	% Hysteresis loss density
Peddyst=((1/iron_density)*pi^2*(f^fEddyExp)*...
			(lamThick^lamThkExp)*(Bin.^BEddyExp))/(6*rho_iron);%	Eddy current loss density

Piron=Physt+Peddyst;%	Iron Loss density


