rhy=(rDo-rDi)/2-hpm;
lc=tauPole*lcpertau;
lcr=lc+dlpm;
%  average diameter of linne field in the stator
Dx = sDo - (2/3)*(sDo - (sDi+(2*shOA)));	% 
%	average diameter of linne field in the rotor
Dy = (rDo - (2*hpm))- (1/3)*((rDo - (2*hpm))-rDi);
%----------Overhang Dimension---------------
cSpan=round(cSpan*q1*nphase)/(q1*nphase); 
sOverhangLength =pi/2*tauPole*cSpan*(1+shOA/sDi)+2*lf1;

%	Other secondary dimensions and factors
lcEff=lc*sf;	%effective iron core length mm.

sSlotArea=(sh4*sMs)+sh3*(sMs+sW3)/2+sh2*(sW3+sW2)/2+sh1*(sW2+sW1)/2;
sSlotWindingArea=(sh1-slotInsulThick)*(sW2+sW1-4*slotInsulThick)/2; %slot area need for windings

hage=hag+hpm*Br_20/(Hc_20*mu_0);
gama=(sMs/hage)^2/(5+sMs/hage);
Kc=tauSslot/(tauSslot-gama*sMs);

sToothTop=swp; sToothRoot=swp;	% mm - pole pitch

%sBareD=2*sqrt((sSlotWindingArea*sSlotFill/CpS)/pi); % mm diameter of stator equivalent bare


%---------Winding Details-------------------
MLC =  sOverhangLength + lc;	%Length of the mean conductor mm
%dce=sBareD/sqrt(nce);
%m1=sh1/sqrt(0.5*(sW1+sW2)*sh1/(sb*nce)); %elementary conductors layers 

% Resistances
rho1=rho_copper*(1+(Tw1-20)*alpha_copper);
sR01 =rho1*MLC/(sSlotWindingArea*sSlotFill*mm2m)*(sSlots/nphase)*(layers/ParallelPaths)^2;

if cSpan>1, k2=(3*(2-cSpan)+1)/4;
elseif cSpan>0.6666, k2=(1+3*cSpan)/4;
else k2=(6*cSpan-1)/4;
end
k1=(1+3*k2)/4;
b1=(sW1+sW2)^2/(0.25*(3*sW1+sW2)+0.5*sW1^2*(sW2-3*sW1)/(sW1-sW2)^2+...
    sW1^4*log(sW1/sW2)/((sW1-sW2)^3));
b2=(sW2-sW3)/log(sW2/sW3);
b3=(sW3-sMs)/log(sW3/sMs);
sh=[sh4, sh3, sh2];
sw=[sMs, b3, b2];
%lamda_s=sh1*k1/b1+(sh4/sMs+sh2/b2+sh3/b3)*k2; % aproximation method
lamda_ss=sh1*k1/b1+k2*sum(sh./sw);						% stator slot permeance
lamda_sO=0.34*q1*(sOverhangLength-0.64*(sDi+shOA)/poles*cSpan)/lc; %end-coil permeance 
						% rotor end ring permeance
k01=1-0.033*sMs^2/(hage*tauSslot);

N1=0.5*poles*q1*layers/ParallelPaths; %Numarul de spire pe faza
Lsl1=2*mu_0*N1^2*lc*mm2m*(lamda_ss+lamda_sO)/(0.5*poles*q1);    	% stator leakage inductance
Lm01=2*nphase*mu_0*(N1*fw/pi)^2*lc*mm2m*tauPole/(0.5*poles*Kc*hage);
Ls1=Lsl1+Lm01;

flux_mp;
Fipolar=2*Bag*tauPole*lc*mm2m^2*sin(alpm*pi/2)/pi;
Psipm1=Fipolar*fw*q1*0.5*layers*poles/ParallelPaths;  % peak value
Iq1=2*Mn/(1.5*poles*Psipm1);    % peak value

sb_c=Vfn/(sqrt(((2*pi*fn*Psipm1+sR01*Iq1)^2+(2*pi*fn*Ls1*Iq1)^2)/2)); %Turns per phase
%sb_c=N1*ParallelPaths/(poles*q1); %turns per coil
sb=round(sb_c); if (sb==0) sb=1; end
N1=0.5*poles*q1*sb*layers/ParallelPaths; %Numarul de spire pe faza
lc=sb_c*lc/sb;
lff=2*lf1+tauPole*cSpan*(1+shOA/sDi)+lc;
MLC =  sOverhangLength + lc;

Fipolar=2*Bag*tauPole*lc*mm2m^2*sin(alpm*pi/2)/pi;
Psipm=Fipolar*N1*fw;  % peak value
Iq=sqrt(2)*Mn/(1.5*poles*Psipm);    % rms value
sR0 =sb^2*rho1*MLC/(sSlotWindingArea*sSlotFill*mm2m)*(sSlots/nphase)*(layers/ParallelPaths)^2;
Lsl=2*mu_0*N1^2*lc*mm2m*(lamda_ss+lamda_sO)/(0.5*poles*q1);    	% stator leakage inductance
Lm0=2*nphase*mu_0*(N1*fw/pi)^2*lc*mm2m*tauPole/(0.5*poles*Kc*hage);
Ls=Lsl+Lm0;


%---------Winding Weight--------------------
WeightStCu=MLC*sSlots*sSlotWindingArea*sSlotFill*copper_density*1e-9;	%kg
WeightPM=pi*(sDo-hpm)*hpm*lcr*mm2m^3*pm_density; %kg
%----------- Iron weights & volumes ----------------
%	Total usage
WeightIronUsed = (sDo*mm2m)^2*lcEff*mm2m*iron_density; % kg

%	For estimation of iron loss
WeightStCoreIron = pi*(((sDo*mm2m)^2-((sDi+(2*shOA))*mm2m)^2)/4)...
   *lcEff*mm2m*iron_density; %	kg
VolStCoreIron = pi*(((sDo*mm2dcm)^2-((sDi+(2*shOA))*mm2dcm)^2)/4)...
   *lcEff*mm2dcm; %	Dcm^3
WeightStTeethIron = sSlots*0.5*(sToothTop+sToothRoot)*mm2m...
                    	*shOA*mm2m*lcEff*mm2m*iron_density; % kg
VolStTeethIron =sSlots*0.5*(sToothTop+sToothRoot)*mm2dcm...
                    	*shOA*mm2dcm*lcEff*mm2dcm; % Dcm^3

WeightStIron=WeightStCoreIron+WeightStTeethIron;	% Stator iron weight
WeightSt=WeightStIron+WeightStCu;		%Kg

%Weight of rotor
rDaux=rDo-2*hpm;
WeightRtCoreIron = 0.25*pi*(rDaux^2-rDi^2)*lcr*iron_density*1e-9; %	kg
VolRtCoreIron =  0.25*pi*(rDaux^2-rDi^2)*lcr*1e-6; %	Dcm^3
WeightPM=0.25*pi*alpm*(rDo^2-rDaux^2)*lcr*pm_density*1e-9; %	kg
WeightRt=WeightRtCoreIron+WeightPM;
WeightMot=WeightSt+WeightRt;
rJ=0.125*((rDo^2+rDaux^2)*WeightPM+(rDaux^2+rDi^2)*WeightRtCoreIron)*1e-6;

[spLossCore spHysLossCore spEddyLossCore]=makeIronLoss(sBy,fn);
IronLossCore=spLossCore*WeightStCoreIron;
[spLossTooth spHysLossTooth spEddyLossTooth]=makeIronLoss(sBt,fn);
IronLossTeeth = spLossTooth*WeightStTeethIron;
Pfe=IronLossCore+IronLossTeeth;
Pcu=nphase*sR0*Iq^2/2;
etan=Pn*1000/(Pn*1000+Pcu+Pfe+Pmec);