
% Electrical rated parameters 
Pn=2.200000;	% W  - rated power 
fn=50.000000;	% Hz - rated frequency 
Vfn=220.000000;	% V  - dc voltage 
Iq=3.877380;	% A  - rms value   
Pcu=100.161830;		% W - Rated copper loss 
Pfe=40.092678;		% W - Rated iron loss 
Pmec=11.000000;   % W - Mechanical loss (given in input file) 
etan=0.935671;	% W - Rated efficiency 

% Constructive dimensions 
sDo=133.000000;	% mm - Stator outer diameter 
sDi=73.000000;	% mm - Stator inner diameter 
sh4=0.500000;	% mm - Stator tooth pole tip height- fig.3.1
sh3=0.678741;	% mm - Stator wedge place height - fig.3.1
shOA=21.436184;	% mm - overall slot height  - fig.3.1
shy=8.563816;	% mm - Stator yoke width 
swp=4.401403;	% mm - Stator tooth width 
hag=1.500000;	% mm - Air-gap height 
hpm=3.200000;	% mm - PM height
lcpertau=2.100000;	% mm - Core stack length
sh1=19.607443;	% mm - Stator coil height 
sW1=10.811139;	% mm - Stator slot width (root)
sW2=5.648401;	% mm - Stator coil width (top)
sMs=2.200000;	% mm - Stator slot mouth 
R1=37.678741;	    % mm - Radius of tooth head  
N1=316.000000;		%  Turns per coil 
rDo=70.000000;	 %mm - Rotor outer diameter 
rDi=48.000000;	 %mm - Rotor inner diameter

% Weights
WeightIronUsed=15.449445;	% kg - Stator core mass 
WeightStCu=3.091677;	% kg - total cooper mass 
WeightPM=0.563305;		% kg - total PM mass 
WeightRtIron=1.305450;		% kg - Rotor mass 
WeightMot=9.862102;	% kg -Motor total mass 

% Costs
cu_c=30.916773		% USD Copper cost
lam_c=77.247223	% USD Lamination cost
PM_c=28.165270		% USD PM cost
rotIron_c=6.527249	% USD PM cost
pmw_c=49.310509	% USD passive material cost
i_cost=192.167023 	% USD initial cost
energy_c=226.881762 % USD energy loss cost
t_cost=419.048785	% USD total cost


 % -------------------------------------------------------------------------------


		 %This outputs was produced using the next data as input:
%Data In
Pn=2.2;	% KW  - rated power
fn=50;	% Hz - base speed
Vfn=220; % V  - phase voltage

%Primary Dimension
poles=4;	% number of poles
nphase=3;   % number of phase
ParallelPaths=1; % parallel current path

%Optimization variable limitations
elsp_min=15;       %kA/m	Minimum	  Specificate electric load 
Bagsp_min=0.45;       %T	Minimum		Specificate magnetic inductin in air gap 
sBt_min=1;         %T	Mimnimum	Specificate magnetic inductin in stator Tooth
sBy_min=0.9;       %T   Minimum	magnetic induction in stator yoke
rBy_min=0.9;       %T   Minimum	magnetic induction in rotor yoke
Js_min=3;          %a/mm^2 Minimum stator current density
lcpertau_min=0.5;  %mm Minimum value of Core stack length
q1_min=2;          % number of stator slots per pole per phase
sMs_min=1;         %mm  Minimum value of Stator open width
sh4_min=0.5;       %mm  Minimum value of Stator tooth pole tip height
cSpan_min=0.66;    % Coil open
alpm_min=0.5; % acoperirea polara magnet permanent

elsp_max=30;       %kA/m	Maximum	  Specificate electric load 
Bagsp_max=0.75;     %T  Maximum	Specificate magnetic inductin in air gap
sBt_max=2;         %T  Maximum	Specificate magnetic inductin in stator Tooth
sBy_max=1.9;       %T  Maximum	magnetic induction in stator yoke 
rBy_max=2.1;       %T  Maximum	magnetic induction in rotor yoke 
Js_max=8;          %a/mm^2 Maximum stator current density
lcpertau_max=3;    %mm Maximum value of Core stack length
q1_max=4;	       % number of stator slots per pole per phase
sMs_max=5;        %mm Maximum value of Stator open width
sh4_max=2;         %mm Maximum value of Stator tooth pole tip height
cSpan_max=1;       % Coil open
alpm_max=1;  % acoperirea polara magnet permanent

%Minimum variation
dXmin=[0.2 0.01 0.05 0.02 0.02 0.1 0.1 1 0.2 0.1 0.05 0.01];

%Extra constrain
%eta_min=0.92; % minimum efficiency 
n1_pu=1;	  % tipically speed 
kn1=0.9;	  % probability of the typical speed	

%Secondary data prescriptin
%layers=2;
layers=1;

%Technological dimensions
etaSpec=0.8;		         %Randamentul
cosPhiSpec=0.95;	         %Factorul de putere
hag_min=0.5;

sAlpha=22.5;% degrees - wedge angle
slotInsulThick = 0.15;	%	Thickness of slot insulation
slotClosureThick = 0.5;	%	Thickness of slot closure (wedge)
lf1=8;		% mm - right part of overhang coils
sSlotFill=0.4;	 % slot filling factor
sf=0.97;		% - stacking factor
nce=1;		% number of elementary conductors
dlpm=2;      %mm PM over-length
Kso=1;
kl=1.8; % over load factor

%Geometric minimum dimensions
rDo_min=8;    % mm
rDi_min=8;    % mm - Minimum shaft diameter
sTeethAlpha_min=0;
sh3_min=0;         % mm
shOA_min=4;       % mm
sh1_min=4;   % mm - Minimum stator coil height 
sW3_min=2;   % mm
%sSlotWindingArea_min=10; 

dk66_65;	% Magnetic material data for stator
VAC677;		% Permanent magnet

%Objective function coefficients
cu_pr=10; %USD/kg copper price
lam_pr=5; %USD/kg lamination price
PM_pr=50; %USD/kg PM price
rotIron_pr=5; %USD/kg - shaft iron price
energy_pr=0.1; %USD/kWh energy price
pmw_pr=5; %USD/kg passive material price
hpy=1500; %h hour per year
ny=10; %years of use
kct=1; %over temperature penalty cost coefficient 

% Other specification
Tw1=105; % deg. C - stator winding temperature
Tpm=100; % deg. C - rotor PM temperature
Tw_max=155; %deg.C - maximum winding temperature
Tamb=50; %deg.C - temperature of cooling fluid
alpha_t=14.2; %W/m^2*deg. thermal transmission coefficient
kff=3; %increasing factor of cooling surface
kpfe=1.45; % iron losses factor (the iron loss are larger due field non-uniformity)
Pmec=5*Pn; %assumed mechanical losses in W
Pem_n=1000*Pn+Pmec;	% W - rated electromechanically power
run_mode='o'; % Run mode: 'o' - optimization, 'e' - performances evaluation
output_file='pmm1_hgout.m'; % Name of the output file
t_file='pmm_hg.txt'; % Name of the table output file
trace_file='pmm_hg1';				% Name of the trace file for optimization