gen=1:length(t_cost_best);     

if(exist('gx')==1)
    xname='Generation';
    figure
    plot(gen,c_min,'o',gen,c_max,'*',gen,c_med,'.');
    grid
    legend('cost min','cost max','costmed');
    xlabel('Generation');
    ylabel('Cost function');
else
    xname='steps';
end

figure
subplot(1,2,1);
plot(gen,sDo_best,'o',gen,sDi_best,'*',gen,rDo_best,'.',gen,rDi_best,'^');
grid
legend('Dso','Dsi','Dro','Dri');   
xlabel(xname);
ylabel('(mm)');
title('Main dimension');

subplot(1,2,2);
[backgr,map]=imread('pmm1.gif');
image(backgr)
colormap(map)
axis off

figure
subplot(1,2,1);
plot(gen,sh4_best,'o',gen,sh3_best,'*',gen,hag_best,'.',gen,hpm_best,'^',gen,sMs_best,'+');
grid
legend('hs4','hs3','air-gap','PM height','so');   
xlabel(xname);
ylabel('(mm)');
title('Slot and PM dimension');

subplot(1,2,2);
[backgr,map]=imread('pmmslot.gif');
image(backgr)
colormap(map)
axis off

figure
plot(gen,Pcu_best,'o',gen,Pfe_best,'*',gen,Pmec_best,'.');
grid
legend('Pcu','Pfe','Pmec');
xlabel(xname);
ylabel('Power (W)');
title('Power losses');

figure
plot(gen,etan_best,'o');
legend('etan')
grid
xlabel(xname);
ylabel('Efficiency');

figure
plot(gen,WeightIronUsed_best,'o',gen,WeightStIron_best,'p',gen,WeightStCu_best,'*',gen,WeightPM_best,'.',...
    gen,WeightRtIron_best,'^',gen,WeightMot_best,'+');
grid
legend('IronUsed','Stator Iron','Copper','PM','Rotor Iron','Machine');   
xlabel(xname);
ylabel('Weight (kg)');
title('Components weigth');

figure
plot(gen,cu_c_best,'o',gen,lam_c_best,'*',gen,PM_c_best,'.',gen,rotIron_c_best,'^',gen,pmw_c_best,'+');
grid
legend('Copper','Lamination','PM','Rotor Iron','weight');   
xlabel(xname);
ylabel('Material cost (USD)');

figure
plot(gen,i_cost_best,'*',gen,energy_c_best,'.',gen,t_cost_best,'o');
grid
legend('initial','energy','total');   
xlabel(xname);
ylabel('Cost component (USD)');

figure
plot(gen,Xbest(:,1),'o');
grid;
xlabel(xname);
ylabel('(kA/m)');
title('Specific electric load');

figure
plot(gen,Xbest(:,2),'o',gen,Xbest(:,3),'*',gen,Xbest(:,4),'.',gen,Xbest(:,5),'^');
grid;
legend('Air-gap','Stator tooth', 'Stator yoke','Rotor yoke');
xlabel(xname);
ylabel('Flux density (T)');
title('Specific flux density');

figure
plot(gen,Xbest(:,6),'o');
grid;
xlabel(xname);
ylabel('(A/mm^2)');
title('Current density');

figure
plot(gen,Xbest(:,7),'o',gen,Xbest(:,11),'*',gen,Xbest(:,12),'.');
grid;
xlabel(xname);
legend('core length to pole pitch','coil span to pole pitch','PM width to pole pitch');

figure
plot(gen,Xbest(:,8),'o');
xlabel(xname);
title('Slots per pole per phase');
grid

if(exist('gx')==1)
member=1:np;
figure
plot(member,costm,'o')
grid
xlabel('member');
ylabel('Cost function');
title('Last generation');

for ii=1:np
     Xlast(ii,:)=Xmin+gx(ii,:).*dXmin;
 end
 
figure
plot(member,Xlast(:,1),'o');
grid;
xlabel('member');
ylabel('(kA/m)');
title('Specific electric load');

figure
plot(member,Xlast(:,2),'o',member,Xlast(:,3),'*',member,Xlast(:,4),'.',member,Xlast(:,5),'^');
grid;
legend('air-gap','stator tooth', 'stator yoke','rotor yoke');
xlabel('member');
ylabel('Flux density (T)');
title('Specific flux density');

figure
plot(member,Xlast(:,6),'o');
grid;
xlabel('member');
ylabel('(A/mm^2)');
title('Current density');

figure
plot(member,Xlast(:,7),'o',member,Xlast(:,11),'*',member,Xlast(:,12),'.');
grid;
xlabel('member');
legend('core length to pole pitch','coil span to pole pitch','PM width to pole pitch');

figure
plot(member,Xlast(:,8),'o');
xlabel('member');
title('Slots per pole per phase');
grid
end