fid=fopen(output_file,'w');
fprintf(fid,'\n%% Electrical rated parameters \n');
fprintf(fid,'Pn=%f;	%% W  - rated power \n', Pn);
fprintf(fid,'fn=%f;	%% Hz - rated frequency \n', fn);
fprintf(fid,'Vfn=%f;	%% V  - dc voltage \n', Vfn);
fprintf(fid,'Iq=%f;	%% A  - rms value   \n', Iq);

fprintf(fid,'Pcu=%f;		%% W - Rated copper loss \n', Pcu);
fprintf(fid,'Pfe=%f;		%% W - Rated iron loss \n', Pfe);
fprintf(fid,'Pmec=%f;   %% W - Mechanical loss (given in input file) \n',Pmec); 
fprintf(fid,'etan=%f;	%% W - Rated efficiency \n', etan);

fprintf(fid,'\n%% Constructive dimensions \n');
fprintf(fid,'sDo=%f;	%% mm - Stator outer diameter \n', sDo);
fprintf(fid,'sDi=%f;	%% mm - Stator inner diameter \n', sDi);
fprintf(fid,'sh4=%f;	%% mm - Stator tooth pole tip height- fig.3.1\n',sh4);
fprintf(fid,'sh3=%f;	%% mm - Stator wedge place height - fig.3.1\n',sh3);
fprintf(fid,'shOA=%f;	%% mm - overall slot height  - fig.3.1\n',shOA);                         
fprintf(fid,'shy=%f;	%% mm - Stator yoke width \n', shy);
fprintf(fid,'swp=%f;	%% mm - Stator tooth width \n', swp);
fprintf(fid,'hag=%f;	%% mm - Air-gap height \n', hag);
fprintf(fid,'hpm=%f;	%% mm - PM height\n', hpm);
fprintf(fid,'lcpertau=%f;	%% mm - Core stack length\n', lcpertau);

fprintf(fid,'sh1=%f;	%% mm - Stator coil height \n', sh1);
fprintf(fid,'sW1=%f;	%% mm - Stator slot width (root)\n', sW1);
fprintf(fid,'sW2=%f;	%% mm - Stator coil width (top)\n', sW2);
fprintf(fid,'sMs=%f;	%% mm - Stator slot mouth \n', sMs);
fprintf(fid,'R1=%f;	    %% mm - Radius of tooth head  \n', sDi/2+sh3+sh4);
fprintf(fid,'N1=%f;		%%  Turns per coil \n', N1);
fprintf(fid,'rDo=%f;	 %%mm - Rotor outer diameter \n', rDo);
fprintf(fid,'rDi=%f;	 %%mm - Rotor inner diameter\n', rDi);

fprintf(fid,'\n%% Weights\n');
fprintf(fid,'WeightIronUsed=%f;	%% kg - Stator core mass \n', WeightIronUsed);
fprintf(fid,'WeightStCu=%f;	%% kg - total cooper mass \n', WeightStCu);
fprintf(fid,'WeightPM=%f;		%% kg - total PM mass \n', WeightPM);
fprintf(fid,'WeightRtIron=%f;		%% kg - Rotor mass \n', WeightRtCoreIron);
fprintf(fid,'WeightMot=%f;	%% kg -Motor total mass \n', WeightMot);

fprintf(fid,'\n%% Costs\n');
fprintf(fid,'cu_c=%f		%% USD Copper cost\n', cu_c);
fprintf(fid,'lam_c=%f	%% USD Lamination cost\n', lam_c);
fprintf(fid,'PM_c=%f		%% USD PM cost\n',PM_c);
fprintf(fid,'rotIron_c=%f	%% USD PM cost\n',rotIron_c);
fprintf(fid,'pmw_c=%f	%% USD passive material cost\n',pmw_c);
fprintf(fid,'i_cost=%f 	%% USD initial cost\n',i_cost);
fprintf(fid,'energy_c=%f %% USD energy loss cost\n',energy_c);
fprintf(fid,'t_cost=%f	%% USD total cost\n',t_cost);

fprintf(fid,'\n\n %% -------------------------------------------------------------------------------\n');
fprintf(fid,'\n\n\t\t %%This outputs was produced using the next data as input:\n');

fid2=fopen([f_input,'.m'],'r');
while 1
	[line,lt]=fgets(fid2);
	if ~isstr(line), break, end
	fprintf(fid,'%s',line);
end
fclose(fid2);

fclose(fid);