hage=hag+hpm*Br_20/(Hc_20*mu_0);
gama=(sMs/hage)^2/(5+sMs/hage);
Kc=tauSslot/(tauSslot-gama*sMs);

sToothTop=swp; sToothRoot=swp;	% mm - pole pitch
lcr=lc+dlpm;

CpS=sb*layers;	%Conductors per slot
sBareD=2*sqrt((sSlotWindingArea*sSlotFill/CpS)/pi); % mm diameter of stator equivalent bare

cSpan=round(cSpan*q1*nphase)/(q1*nphase); 

%----------Overhang Dimension---------------
sOverhangLength =pi/2*tauPole*cSpan*(1+shOA/sDi)+2*lf1;
lff=2*lf1+tauPole*cSpan*(1+shOA/sDi)+lc;

%	Other secondary dimensions and factors
lcEff=lc*sf;	%effective iron core length mm.

%---------Winding Details-------------------
CPhY=CpS*(sSlots/(nphase*ParallelPaths));	%Conductors per phase
MLC =  sOverhangLength + lc;	%Length of the mean conductor mm
wireCSA = ((pi*sBareD^2)/4)*1e-6; %Wire CSA m^2
dce=sBareD/sqrt(nce);
m1=sh1/sqrt(0.5*(sW1+sW2)*sh1/(sb*nce)); %elementary conductors layers 

% stator
Dx = sDo - (2/3)*(sDo - (sDi+(2*shOA)));	% Corrected 99-10-18 AER
%	rotor
Dy = (rDo - (2*hpm))- (1/3)*((rDo - (2*hpm))-rDi);
%---------Winding Weight--------------------
WeightStCu=CPhY*ParallelPaths*nphase*wireCSA*MLC*copper_density*1e-3;	%kg
WeightPM=pi*(sDo-hpm)*hpm*lcr*mm2m^3*pm_density; %kg
Weightmr=pi*(rDi+rhy)*rhy*lcr*mm2m^3*iron_density;
%----------- Iron weights & volumes ----------------
%	Total usage
WeightIronUsed = (sDo*mm2m)^2*lcEff*mm2m*iron_density; % kg

%	For estimation of iron loss
WeightStCoreIron = pi*(((sDo*mm2m)^2-((sDi+(2*shOA))*mm2m)^2)/4)...
   *lcEff*mm2m*iron_density; %	kg
VolStCoreIron = pi*(((sDo*mm2dcm)^2-((sDi+(2*shOA))*mm2dcm)^2)/4)...
   *lcEff*mm2dcm; %	Dcm^3
WeightStTeethIron = sSlots*0.5*(sToothTop+sToothRoot)*mm2m...
                    	*shOA*mm2m*lcEff*mm2m*iron_density; % kg
VolStTeethIron =sSlots*0.5*(sToothTop+sToothRoot)*mm2dcm...
                    	*shOA*mm2dcm*lcEff*mm2dcm; % Dcm^3

WeightStIron=WeightStCoreIron+WeightStTeethIron;	% Stator iron weight
WeightSt=WeightStIron+WeightStCu;		%Kg


%Weight of rotor
rDaux=rDo-2*hpm;
WeightRtCoreIron = 0.25*pi*(rDaux^2-rDi^2)*lcr*iron_density*1e-9; %	kg
VolRtCoreIron =  0.25*pi*(rDaux^2-rDi^2)*lcr*1e-6; %	Dcm^3
WeightPM=0.25*pi*alpm*(rDo^2-rDaux^2)*lcr*pm_density*1e-9; %	kg
WeightRt=WeightRtCoreIron+WeightPM;
WeightM=WeightSt+WeightRt;
rJ=0.125*((rDo^2+rDaux^2)*WeightPM+(rDaux^2+rDi^2)*WeightRtCoreIron)*1e-6;