%Main program;

clc;

%Opening main figure;
figNumber=figure(...
	'NumberTitle','off',...
	'Name','Welcome to Electric Machines example kit!',...
    'CloseRequestFcn','disp(''Press Exit Button to close the applications'')',...
    'Resize','off',...
    'MenuBar','none',...
	'Position',[100 50 500 400],...
	'Pointer','arrow');
set(gca,'position',[0 0 1 1]);
axHndl1=gca;
axHndl=axes(...
	'Units','pixels',...
	'Position',[0 0 500 400],...
	'Visible','off');

%Loading background image;
[backgr,map]=imread('e_machines.jpg');
image(backgr)
colormap(map)
axis off

%******************** HELP Button ******************
hlpStr= ...                          
   ['                                                       '
	'  1. From this control panel select the drive you want '  
    'to study. Do this from popup - pull - down menus. An   '    
    'additional help is also available for each category of '
	'drive including more details about that simulation.    '
	'The control panel includes an Exit button, too...      '
	'  2. After selecting the desired example, the          '
	'user interface or block diagram in Simulink appears.   '
	'  3. Each example has its embeded parameter.           '
	'  4. Modify these parameters, in order to study system '
	'behaviour, by clicking on blocks. Each block contains  '
	'a short help with its parameter settings, input/output '
	'variables.                                             '
	'  5. Simulation menu of the main window contains the   '
	'Start / Stop / Pause option for example runing         '
	'control.                                               '];
callbackStr=[...
	'titleStr=''Electric Machines Help'';',...
	'helpdlg(hlpStr,titleStr);'];
HelpHandl=uicontrol(...
	'Style','pushbutton',...
	'Units','pixels',...
	'Position',[20 10 80 20],...
	'String','HELP...',...
	'Enable','on',...
	'Callback',callbackStr);


%*************** EXIT Button *******************
callbackStr=[...
	'closereq;',...
    'clear;',...
    'close;'];
ExitHandl=uicontrol(...
	'Style','pushbutton',...
	'Units','pixels',...
	'Position',[400 10 80 20],...
	'String','Exit',...
	'Enable','on',...
	'Callback',callbackStr);

%*********** Transformer Steady State Example *************************

label1=text(...
	'Position',[120,280],...
	'Units','pixels',...
	'FontAngle','italic',...
	'String','Transformer');
callStr1='Transformer';
Transformer=uicontrol('Style','Popup','BackgroundColor',[1 1 1],'String',...
    ['Select an example                                '
     'Example 1 - Magnetic circuit                     '
     'Example 2 - Transformer steady state             '
     'Example 3 - Transformer unbalanced load current  '
     'Example 4 - Transformer unbalanced load impedance'],...
	'Units','pixels',...
	'Position',[80 250 255 20],...
	'Callback','sel_menu(callStr1,Transformer)');

% Create the Transformer Steady State Help button;
hlpStr_I= ...                          
   ['                                                      '
	'Example 1:                                            '
	'  - Magnetic circuit                                  '
	'______________________________________________________'  
    'Example 2:                                            '
	'  - Transformer steady state example                  '
	'------------------------------------------------------'
	'Example 3:                                            '
	'  - Three phase Transformer unbalanced load current   '
    '------------------------------------------------------'
	'Example 4:                                            '
	'  - Three phase Transformer unbalanced load parameters'
    '______________________________________________________'];
callbackStr=[...
	'titleStr=''Transformer Steady State Example Help'';',...
	'helpdlg(hlpStr_I),titleStr;'];
IndHelpHandl=uicontrol(...
	'Style','pushbutton',...
	'Units','pixels',...
	'Position',[350 250 80 20],...
	'String','HELP...',...
	'Enable','on',...
	'Callback',callbackStr);


%*************** DC MOTOR Example ********************

label2=text(...
	'Position',[120,230],...
	'Units','pixels',...
	'FontAngle','italic',...
	'String','DC Steady State motor');
callStr2='DCmotor';
DCmotor=uicontrol(...
	'Style','Popup',...
	'BackgroundColor',[1 1 1],...
	'String',...
   ['Select an example                     '
    'Example 5 - Separated excited dc motor'
    'Example 6 - Series excited dc motor   '],...
	'Units','pixels',...
	'Position',[80 200 255 20],...
	'Callback','sel_menu(callStr2,DCmotor)');

% Create the DCmotor Help button;
hlpStr_S= ...                          
   ['                                                      '
	'Example 5:                                            '
	'  -  Derivation excited DC motor                      '
    '------------------------------------------------------'
	'Example 6:                                            '
	'  - Series excited DC motor                           '
	'______________________________________________________'];
callbackStr=[...
	'titleStr=''DC steady state motor example Help'';',...
	'helpdlg(hlpStr_S,titleStr);'];
DCmotorHandl=uicontrol(...
	'Style','pushbutton',...
	'Units','pixels',...
	'Position',[350 200 80 20],...
	'String','HELP...',...
	'Enable','on',...
	'Callback',callbackStr);

%**************** AC MOTOR EXAMPLE *****************

label3=text(...
	'Position',[120,180],...
	'Units','pixels',...
	'FontAngle','italic',...
	'String','AC motor steady state');
callStr3='ACmotor';
ACmotor=uicontrol(...
	'Style','Popup',...
	'BackgroundColor',[1 1 1],...
	'String',...
    ['Select example                                '
     'Example 7 - Induction motor characteristics   '
     'Example 8 -  Synchronous motor characteristics'],...
	'Units','pixels',...
	'Position',[80 150 255 20],...
	'Callback','sel_menu(callStr3,ACmotor)');

% Create the ACmotorHelp button;
hlpStr_B= ...                          
   ['                                                      '
	'Example 7:                                            '
	'  -  Induction motor                                  '
    '------------------------------------------------------'
	'Example 8:                                            '
	'  -  Synchronous motor                                '    
	'______________________________________________________'];
callbackStr=[...
	'titleStr=''AC Steady State Motor Example Help'';',...
	'helpdlg(hlpStr_B,titleStr);'];
ACHelpHandl=uicontrol(...
	'Style','pushbutton',...
	'Units','pixels',...
	'Position',[350 150 80 20],...
	'String','HELP...',...
	'Enable','on',...
	'Callback',callbackStr);

%******************** TRANSIENTS REGIME **********************

label4=text(...
	'Position',[120,130],...
	'Units','pixels',...
	'FontAngle','italic',...
	'String','Transients');
callStr4='Transient';
Transient=uicontrol(...
	'Style','Popup',...
	'BackgroundColor',[1 1 1],...
	'String',...
  ['Select example                                    '
   'Example 9a - No load transformer - grid connection'
   'Example 9b - Loaded transformer - grid connection '
   'Example 10 - DC motor transients                  ' 
   'Example 11 - Induction motor transients           '
   'Example 12 - Synchronous motor transients         '],...
	'Units','pixels',...
	'Position',[80 100 255 20],...
	'Callback','sel_menu(callStr4,Transient)');

% Create the TransientHelp button;
hlpStr_D= ...                          
   ['                                                      '
	'Example 9a:                                           '
	'  - Transformer - grid connection                     '
    '------------------------------------------------------'
    'Example 9b:                                           '
	'  - No load Transformer - grid connection             '
    '------------------------------------------------------'
    'Example 10:                                           '
	'  - DC motor                                          '
    '------------------------------------------------------'
    'Example 11:                                           '
	'  -  Induction motor                                  '
    '------------------------------------------------------'
	'Example 12:                                           '
	'  -  Synchronous motor                                '
	'______________________________________________________'];
callbackStr=[...
	'titleStr=''Transients Machine Simulation Help'';',...
	'helpdlg(hlpStr_D,titleStr);'];
DCHelpHandl=uicontrol(...
	'Style','pushbutton',...
	'Units','pixels',...
	'Position',[350 100 80 20],...
	'String','HELP...',...
	'Enable','on',...
	'Callback',callbackStr);

%****************** OPTIMAL DESIGN ***************************

label5=text(...
	'Position',[120,80],...
	'Units','pixels',...
	'FontAngle','italic',...
	'String','Optimal design');
callStr5='OptDesign';
OptDesign=uicontrol(...
	'Style','Popup',...
	'BackgroundColor',[1 1 1],...
	'String',...
   ['Select example                                   ' 
    'Example 13 - Induction Motor by H. J. algorithm  '
    'Example 14 - Induction Motor by GA               '
    'Example 15 - Synchronous Motor by H. J. algorithm'
    'Example 16 - Synchronous Motor by GA             '
    'Example 17 - IPMSM - Embeded FEM optimal design  '
    'Example 18 - IPMSM - thermal FEM verification    '],...
	'Units','pixels',...
	'Position',[80 50 255 20],...
	'Callback','sel_menu(callStr5,OptDesign,figNumber)');

% Create the OptimDesignHelp button;
hlpStr_SR= ...                          
   ['                                                                    '
	'Example 13:                                                         '
	'  - Optimal design of Induction Motor using Hooke Jeeves algorithm  '
    '--------------------------------------------------------------------'
    'Example 14:                                                         '
	'  - Optimal design of Induction Motor using genetic algorithm       '
    '--------------------------------------------------------------------'
	'Example 15:                                                         '
	'  - Optimal design of Synchronous Motor using Hooke Jeeves algorithm'
    '--------------------------------------------------------------------'
    'Example 16:                                                         '
	'  - Optimal design of Synchronous Motor using genetic algorithm     '
    '--------------------------------------------------------------------'
    'Example 17:                                                         '
	'  - Embeded FEM based optimal design of a PM spoke motor            '
    '--------------------------------------------------------------------'
    'Example 18:                                                         '
	'  - Thermal FEM verification of a PM spoke motor                    '
  	'____________________________________________________________________'];
callbackStr=[...
	'titleStr=''Optimal Design Help'';',...
	'helpdlg(hlpStr_SR,titleStr);'];
OptDesignHelpHandl=uicontrol(...
	'Style','pushbutton',...
	'Units','pixels',...
	'Position',[350 50 80 20],...
	'String','HELP...',...
	'Enable','on',...
	'Callback',callbackStr);