%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%% Simulation Parameters %%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
T = 1 ; % Simulation time
hh = 1000 ; % Number of simulation-steps
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% System-State-Dynamics Parameters %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n = 5 ; % number of players
b0 = 1 ;
b1 = -2 ;
bb1 = -2 ;
b2 = [1 2 3 4 5] ; % b2 = [b_{21},...,b_{2n}]
bb2 = [1 2 3 4 5] ; % bb2 = [\bar{b}_{21},...,\bar{b}_{2n}]
s = 5 ; % \sigma_0
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% Cost functional Parameters %%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
lambda = [1 0.1 0.2 0.3 0.4 ; 
        0.1 1 0.2 0.3 0.4 ; 
        0.1 0.2 1 0.3 0.4 ; 
        0.1 0.2 0.3 1 0.4 ; 
        0.1 0.2 0.3 0.4 1 ] ; % coopetitive parameters
r = [1.1 1.2 1.3 1.4 1.5] ; % r = [r_1,...,r_n]
br = [1.1 1.2 1.3 1.4 1.5] ; % \bar{r} = [\bar{r}_1,...,\bar{r}_n]
q = [1 2 3 4 5] ; % q = [q_1,...,q_n]
bq = [1 2 3 4 5] ; % \bar{q} = [\bar{q}_1,...,\bar{q}_n]
q_T = [0.1 0.2 0.3 0.4 0.5] ; % q(T) = [q_1(T),...,q_n(T)]
bq_T = [0.1 0.1 0.1 0.1 0.1] ; % \bar{q}(T) = [\bar{q}_1(T),...,\bar{q}_n(T)]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Initial Conditions %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x0 = 4 ; % initial condition 
Ex0 = x0 ; % initial condition 
variables0 = [ones(4*n,1);x0;Ex0] ; % variables0 = [\alpha_1,...\alpha_n,\beta_1,...\beta_n,\gamma_1,...\gamma_n,\delta_1,...\delta_n,x,Ex]

Input_Data = struct('T',T,'hh',hh,'n',n,'b0',b0,'b1',b1,'bb1',bb1,...
    'b2',b2,'bb2',bb2,'s',s,'r',r,'br',br,'q',q,'bq',bq,'q_T',q_T,...
    'bq_T',bq_T,'x0',x0,'Ex0',Ex0,'variables0',variables0,'lambda',lambda) ;