%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Authors: Julian Barreiro-Gomez and Hamidou Tembine
% New York University in Abu Dhabi (NYUAD)
% May, 2019
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%% Simulation Parameters %%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
T = 2 ; % Simulation time
hh = 1000 ; % Number of simulation-steps
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% System-State-Dynamics Parameters %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n = 2 ; % number of players
d = 2 ;
B1 = [-1 -2 ; -1 -2] ;
bB1 = [-0.2 -0.1 ; -0.2 -0.1] ;
B2 = zeros(d,d,n) ;
B2(:,:,1) = [0.1 0.1 ; 0.2 0.2] ; %
B2(:,:,2) = [0.2 0.2 ; 0.1 0.1] ; %
%
bB2 = zeros(d,d,n) ;
bB2(:,:,1) = [1 2 ; 3 4] ; %
bB2(:,:,2) = [0.1 0.2 ; 0.3 0.4] ; %
%
S = 3 ; % \sigma_0
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% Cost functional Parameters %%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
R = zeros(d,d,n) ;
R(:,:,1) = eye(d) ; 
R(:,:,2) = 2*eye(d) ; 
%
bR = zeros(d,d,n) ;
bR(:,:,1) = eye(d) ; 
bR(:,:,2) = 2*eye(d) ; 
%
Q = zeros(d,d,n) ;
Q(:,:,1) = 2*eye(d) ; 
Q(:,:,2) = 3*eye(d) ; 
%
bQ = zeros(d,d,n) ;
bQ(:,:,1) = 4*eye(d) ; 
bQ(:,:,2) = 5*eye(d) ; 
%
Q_T = Q ;
bQ_T = bQ ;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Q0 = zeros(d,d) ;
Q0_T = zeros(d,d) ;
bQ0 = zeros(d,d) ;
bQ0_T = zeros(d,d) ;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for i = 1 : n
    Q0 = Q0 + Q(:,:,i) ;
    Q0_T = Q0_T + Q_T(:,:,i) ;
    bQ0 = bQ0 + bQ(:,:,i) ;
    bQ0_T = bQ0_T + bQ_T(:,:,i) ;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Initial Conditions %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x0 = [4 2 ; 3 1] ; % initial condition 
Ex0 = x0 ; % initial condition 
variables0 = [ones(2*d^2+1,1);x0(:);Ex0(:)] ; % 

Input_Data = struct('T',T,'hh',hh,'n',n,'d',d,'B1',B1,'bB1',bB1,...
    'B2',B2,'bB2',bB2,'S',S,'R',R,'bR',bR,'Q0',Q0,'bQ0',bQ0,...
    'Q0_T',Q0_T,'bQ0_T',bQ0_T,'x0',x0,'Ex0',Ex0,'variables0',variables0) ;