%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Authors: Julian Barreiro-Gomez and Hamidou Tembine
% New York University in Abu Dhabi (NYUAD)
% May, 2019
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%% Simulation Parameters %%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
T = 3 ; % Simulation time
hh = 1000 ; % Number of simulation-steps
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% System-State-Dynamics Parameters %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n = 2 ; % number of players
d = 2 ;
B1 = [-1 -2 ; -3 -4] ;
bB1 = [-0.1 -0.2 ; -0.3 -0.4] ;
B2 = zeros(d,d,n) ;
B2(:,:,1) = [0.1 0.1 ; 0.2 0.2] ; %
B2(:,:,2) = [0.1 0.2 ; 0.1 0.2] ; %
%
bB2 = zeros(d,d,n) ;
bB2(:,:,1) = [0.4 0.5 ; 0.6 0.7] ; %
bB2(:,:,2) = [1.4 1.5 ; 1.6 1.7] ; %
%
S = 2 ; % \sigma_0
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% Cost functional Parameters %%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
R = zeros(d,d,n) ;
R(:,:,1) = eye(2) ; 
R(:,:,2) = 2*eye(2) ; 
%
bR = zeros(d,d,n) ;
bR(:,:,1) = eye(2) ; 
bR(:,:,2) = 2*eye(2) ; 
%
Q = zeros(d,d,n) ;
Q(:,:,1) = 0.1*eye(2) ; 
Q(:,:,2) = 0.2*eye(2) ; 
%
bQ = zeros(d,d,n) ;
bQ(:,:,1) = 0.3*eye(2) ; 
bQ(:,:,2) = 0.4*eye(2) ; 
%
Q_T = Q ;
bQ_T = bQ ;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Initial Conditions %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x0 = [1 2 ; 3 4] ; % initial condition 
Ex0 = x0 ; % initial condition 
variables0 = [ones(2*n*d^2+n,1);x0(:);Ex0(:)] ;  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Input_Data = struct('T',T,'hh',hh,'n',n,'d',d,'B1',B1,'bB1',bB1,'B2',B2,...
    'bB2',bB2,'S',S,'R',R,'bR',bR,'Q',Q,'bQ',bQ,'Q_T',Q_T,'bQ_T',bQ_T,...
    'x0',x0,'Ex0',Ex0,'variables0',variables0) ;