%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Authors: Julian Barreiro-Gomez and Hamidou Tembine
% New York University in Abu Dhabi (NYUAD)
% May, 2019
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% EXAMPLE_1

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%% Simulation Parameters %%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
T = 2 ; % Simulation time
hh = 1000 ; % Number of simulation-steps
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% System-State-Dynamics Parameters %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n = 3 ; % number of players
b0 = 1 ;
b1 = -1 ;
bb1 = -1 ;
b2 = [1 2 3] ; % b2 = [b_{21},...,b_{2n}]
bb2 = [1 2 3] ; % bb2 = [\bar{b}_{21},...,\bar{b}_{2n}]
s = 2 ; % \sigma_0
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% Cost functional Parameters %%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
r = [1 2 2] ; % r = [r_1,...,r_n]
br = [1 2 2] ; % \bar{r} = [\bar{r}_1,...,\bar{r}_n]
q = [0.5 0.5 0.5] ; % q = [q_1,...,q_n]
bq = [0.1 0.2 0.3] ; % \bar{q} = [\bar{q}_1,...,\bar{q}_n]
q_T = [0.2 0.3 0.4] ; % q(T) = [q_1(T),...,q_n(T)]
bq_T = [0.1 0.1 0.1] ; % \bar{q}(T) = [\bar{q}_1(T),...,\bar{q}_n(T)]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Initial Conditions %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x0 = 2.5 ; % initial condition 
Ex0 = x0 ; % initial condition 
variables0 = [ones(4*n,1);x0;Ex0] ; % variables0 = [\alpha_1,...\alpha_n,\beta_1,...\beta_n,\gamma_1,...\gamma_n,\delta_1,...\delta_n,x,Ex]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Inputs %%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Input_Data = struct('T',T,'hh',hh,'n',n,'b0',b0,'b1',b1,...
    'bb1',bb1,'b2',b2,'bb2',bb2,'s',s,'r',r,'br',br,'q',q,'bq',bq,...
    'q_T',q_T,'bq_T',bq_T,'x0',x0,'Ex0',Ex0,'variables0',variables0) ;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%