
### SIR from Eberhard book pag. 37 ###

# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 100, by = 0.1) 		# time
state=c(S = 990, I = 10, R = 0)			# initial conditions

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state)),
		{
		dS = 3 + 0.01*R - 0.0005*S*I		# differential equation for X1
		dI = 0.0005*S*I - 0.05*I - 0.02*I			# differential equation for X2
		dR = 0.05*I - 0.01*R

		list(dy=c(dS,dI,dR),cont=NULL) # stating what should be in the output
		})
	}

output = ode(y = state, times = t, func = equations)	# calling the ODE solver and producing the output

plot(output[,1:2],type='l',col = 'blue')  # ploting S
lines(output[,c(1,3)],col='red')				# ploting I
lines(output[,c(1,4)],col='green')






