
### Approach_of_stable_steady_state ###

# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 10, by = 0.1) 		# time
state=c(X1 = 0.5, X2 = 1.2)			# initial conditions

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state)),
		{
		dX1 = -3*X1 - 6*X2		# differential equation for X1
		dX2 = 2*X1 + X2			# differential equation for X2

		list(dy=c(dX1,dX2),cont=NULL) # stating what should be in the output
		})
	}

output = ode(y = state, times = t, func = equations)	# calling the ODE solver and producing the output

plot(output[,1:2],type='l',col = 'blue',ylim=c(-1.8,1.5))  	# ploting X1
lines(output[,c(1,3)],col='red')					# ploting X2
legend(6,1,legend=c('X1','X2'),lty=c(1,1),col=c('blue','red'))

