
### Blue_sky ###

# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 500, by = .1) 		# time
state=c(X1 = 0.91, X2 = 0.4)			# initial conditions
parameters=c(A = 0.265)				# parameters


equations=function(t,state,parameters) 			# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{
		dX1 = X2						# differential equation for X1
		dX2 = X1 - X1^3 - 0.25*X2 + A*sin(t)	# differential equation for X2

		list(dy=c(dX1,dX2),cont=NULL) 		# stating what should be in the output
		})
	}

output = ode(y = state, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output

plot(output[,1:2],type='l',col = 'blue')  		# ploting X1
lines(output[,c(1,3)],col='red')				# ploting X2
legend(300,-0.5,legend=c("X1","X2"),lty=c(1,1),col=c("blue","red"),bty = "n")


