
### Branch_pathway ###

# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 10, by = 0.1) 									# time
state=c(X1 = 2, X2 = 4, X3 = 6, X4 = 0.5, X5 = 0.1, X6 = 0.1)				# initial conditions
parameters=c(    
		X0 = 1,
    		a1 = 5,
    		b1 = .2,
    		b2 = 2,
    		b3 = 2,
    		b4 = 2,
    		c1 = 3,
    		c2 = 0.5,
    		c3 = 0.5,
    		g = -4,
    		h = 2
		)											# parameters


equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{
		dXdt = c(
			a1 * X0 * X4 ^ g - b1 * X1 - c1 * X1 ^ 2 * X4 ^ h,		# dX1dt differential equation for X1
			b1 * X1 - b2 * X2 ^ 0.4,						# dX2dt differential equation for X2
          		b2 * X2 ^ 0.4 - b3 * X3 ^ 0.7,					# dX3dt differential equation for X3
          		b3 * X3 ^ 0.7 - b4 * X4 ^ 0.8,					# dX4dt differential equation for X4
          		c1 * X1 ^ 2 * X4 ^ h - c2 * X5,					# dX5dt differential equation for X5 ?
          		c2 * X5 - c3 * X6								# dX6dt differential equation for X6
			)

		list(dy=c(dXdt),cont=NULL) # stating what should be in the output
		})
	}

output = ode(y = state, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output

plot(output[,1:2],type='l',col = 'blue',ylim=c(0,110))  # ploting X1
lines(output[,c(1,3)],col='red')		# ploting X2
lines(output[,c(1,4)],col='green')		# ploting X3
lines(output[,c(1,5)],col='orange')		# ploting X4
lines(output[,c(1,6)],col='grey')		# ploting X5
lines(output[,c(1,7)],col='cyan')		# ploting X6
legend(0,100,legend=c("X1","X2","X3","X4","X5","X6"),lty=c(1,1,1,1,1,1),col=c("blue","red","green","orange","grey","cyan"),bty = "n")




