
### CF model ###

# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 400, by = 0.1) 									# time
state=c(B = 1278.037, P = 64.7532, A = 15.04461, H = 1713.089, D = 100, M = 12.75542)				# initial conditions

parameters = c(CF = 0)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

    		AB = 0	
    		if (t > 22) {AB = 5}
    		if (t > 32) {AB = 0} 	  
    		if (t > 162) {AB = 5}
    		if (t > 172) {AB = 0}
    		if (t > 302) {AB = 5}
    		if (t > 312) {AB = 0}

		dXdt = c(
			(B^0.8 * M^1.2 - 0.8 * B^1.2 * P^.1 * (AB + 1)) * M^(-2.4),		# dX1dt differential equation for X1
			20 * B^0.2 * D^0.4 * A^-0.1 - 50 * P^0.5,					# dX2dt differential equation for X2
          		15 * B^0.1 * P^0.1 - 12 * A^0.5,								# dX3dt differential equation for X3
          		500 - 40 * H^0.3 * P^0.2 * A^(-0.2),							# dX4dt differential equation for X4
          		40 * H^0.3 * P^0.2 * A^(-0.2) - 5 * D,						# dX5dt differential equation for X5 ?
          		0.16 * B^0.25 * 2^CF - 0.15 * M^(2-1*CF)							# dX6dt differential equation for X6
			)

		list(dy=c(dXdt),cont=NULL) # stating what should be in the output
		})
	}

# perturbations
perturb_infections = data.frame(
					var = c('B','B','B'), 
					time = c(20,160,300),
					value = c(3000,5000,10000), 
					method = c("replace","replace","replace")		#  method ("replace", "add", "multiply")	
					)	

par(mfrow=c(2,2))

parameters = c(CF = 0)
output = ode(y = state, times = t, func = equations, parms = parameters,events = list(data = perturb_infections))	# calling the ODE solver and producing the output
output[201,2] = 3000; output[1601,2] = 5000; output[3001,2] = 10000 # because the solver does not integrate the perturbation values into the solution I am putting then in manually
plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(60,output[,2:7])),main="Wild Type | CF = 0")  # ploting B
lines(output[,c(1,3)],col='red')		# ploting P
lines(output[,c(1,4)],col='green')		# ploting A
lines(output[,c(1,5)],col='orange')		# ploting H
lines(output[,c(1,6)],col='grey')		# ploting D
lines(output[,c(1,7)],col='cyan')		# ploting M
	
library("png")
pp <- readPNG("CFmodel.png")
plot.new() 
rasterImage(pp,0,0,1,1)

parameters = c(CF = 1)
output = ode(y = state, times = t, func = equations, parms = parameters,events = list(data = perturb_infections))	# calling the ODE solver and producing the output
plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(60,output[,2:7])),main="Cystic Fibrosis | CF = 1") # ploting B
lines(output[,c(1,3)],col='red')		# ploting P
lines(output[,c(1,4)],col='green')		# ploting A
lines(output[,c(1,5)],col='orange')		# ploting H
lines(output[,c(1,6)],col='grey')		# ploting D
lines(output[,c(1,7)],col='cyan')		# ploting M

plot.new() 
legend(.3,1.1,legend=c("B","P","A","H","D","M"),lty=c(1,1,1,1,1,1),col=c("blue","red","green","orange","grey","cyan"),bty = "n")
legend(-.1,0.55,legend="Infections occour at t = 20, 160 and 300.",cex=0.9,bty = "n")
legend(-.1,0.45,legend=c("var","B","B","B"),cex=0.9,bty = "n")
legend(.1,0.45,legend=c("t","20","160","300"),cex=0.9,bty = "n")
legend(.3,0.45,legend=c("value","3000","5000","10000"),cex=0.9,bty = "n")
legend(-.1,0.1,legend="Antibiotics are taken 2 days after infection.",cex=0.9,bty = "n")

