
### ExactMMRL ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 20, by = 0.1) 									# time
state=c(S = 100, C = 0, P = 0, SS = 0)				# initial conditions

parameters = c(
		Etot = 4,
		k1 = 1,
		k1r = 0.3, 
		k2 = 1.5
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{
		E = Etot - C

		dXdt = c(
			- k1 * S * E + k1r * C,				# dSdt differential equation for S
          		k1 * S * E - (k1r + k2) * C,    		# dvdt differential equation for v		
			k2 * C,						# dSSdt differential equation for SS
          		5							# dPdotdt differential equation for Pdot
			)

		list(dy=c(dXdt),cont=NULL) # stating what should be in the output
		})
	}

output = ode(y = state, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output

par(mfrow=c(2,1))
plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(60,output[,2:5]))) # ploting S
lines(output[,c(1,3)],col='red')		# ploting v
lines(output[,c(1,4)],col='green')		# ploting SS
lines(output[,c(1,5)],col='orange')		# ploting Pdot
legend(17,80,legend = c('S','v','SS','Pdot'),lty = c(1,1,1,1),col=c('blue','red','green','orange'),bty = "n")

SS = output[,5]
Vmax = parameters[4] * parameters[1]
KM = (parameters[3] + parameters[4]) / parameters[2]
v = Vmax * SS / (KM + SS)
Pdot = parameters[4] * output[,3]

plot(SS,v,type='l',col = 'blue') # ploting v


