
### Fermentation ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 500, by = 0.1) 									# time
state=c(B = 36, E = 60)				# initial conditions

parameters = c(
    		mu_max = 5,
    		K1 = 2,
    		K2 = 10,
    		a = 0.01,
    		b = 0.05,
    		c = 0.03,
    		G = 2
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{
		if (t>100) {G = 4}
		if (t>300) {G = 2}

		dXdt = c(
			mu_max * B * (G / (K1 + G)) * K2 / (K2 + E) - a * B^2,		# dBdt differential equation for B
          		b * B - c * E									# dEdt differential equation for E
			)

		list(dy=c(dXdt),cont=NULL) # stating what should be in the output
		})
	}


output = ode(y = state, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output


plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(60,output[,2:3]))) 	# ploting B
lines(output[,c(1,3)],col='orange')								# ploting E
legend(x = 400,y = 17,legend = c('B','E'),lty = c(1,1),col=c('blue','orange'),bty = "n")










