
### Linearization ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 50, by = 0.1) 						# time
x0=c(X = 8.660143, Y = 2, XX = 0, YY = 0)				# initial conditions

parameters = c(
		    c1 = 3,
		    c2 = 2,
		    c3 = 5,
		    c4 = 6,
		    c5 = 3,
		    n = 2
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{
		Bolus = 0
		if (t>5) {Bolus = 5}
		if (t>6) {Bolus = 0}

		dXdt = c(
			c1 - c2 * Y * X^n / (c3^n + X^n) + Bolus,		# dXdt differential equation for X
          		c4 - c5 * Y,						# dYdt differential equation for Y
			-(c2 * x0[2] * 2 * c3^2 * x0[1] / (c3^2 + x0[1]^2)^2) * XX - (c2 * x0[1]^2 / (c3^2 + x0[1]^2)) * YY + Bolus,	# dXXdt differential equation for XX
			- c5 * YY							# dYYdt differential equation for YY
			)

		list(dy=c(dXdt),cont=NULL) # stating what should be in the output
		})
	}


output = ode(y = x0, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output


plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(20,output[,2:5]))) 	# ploting X
lines(output[,c(1,3)],col='orange')								# ploting Y
lines(output[,1],output[,4] + 8.660143,col='green')					# ploting XXX
lines(output[,1],output[,5] + 2,col='grey')						# ploting YYY
legend(x = 30,y = 20,legend = c('X','Y','XXX','YYY'),lty = c(1,1),col=c('blue','orange','green','grey'),bty = "n")



