
### LotkaChaos ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 300, by = 0.1) 			# time
x0=c(x1 = 1, x2 = 1, x3 = 1, x4 = 1)				# initial conditions

parameters = c(
    r1 = 1,
    r2 = 0.72,
    r3 = 1.53,
    r4 = 1.27,

    a11 = 1,
    a12 = 1.09,
    a13 = 1.52,
    a14 = 0,
    a21 = 0,
    a22 = 1,
    a23 = 0.44,
    a24 = 1.36,
    a31 = 2.33,
    a32 = 0,
    a33 = 1,
    a34 = 0.47,
    a41 = 1.21,
    a42 = 0.51,
    a43 = 0.35,
    a44 = 1
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

		dxdt = c(
			r1 * x1 * (1 - a11 * x1 - a12 * x2 - a13 * x3 - a14 * x4),		# dx1dt differential equation for x1
          		r2 * x2 * (1 - a21 * x1 - a22 * x2 - a23 * x3 - a24 * x4),		# dx2dt differential equation for x2
			r3 * x3 * (1 - a31 * x1 - a32 * x2 - a33 * x3 - a34 * x4),		# dx3dt differential equation for x3
			r4 * x4 * (1 - a41 * x1 - a42 * x2 - a43 * x3 - a44 * x4)		# dx4dt differential equation for x4
			)

		list(dy=c(dxdt),cont=NULL) # stating what should be in the output
		})
	}


output = ode(y = x0, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output


plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(1,output[,2:5]))) 	# ploting x1
lines(output[,c(1,3)],col='orange')							# ploting x2
lines(output[,1],output[,4],col='green')						# ploting x3
lines(output[,1],output[,5],col='grey')						# ploting x4
legend(x = 200,y = 1,legend = c('x1','x2','x3','x4'),lty = c(1,1),col=c('blue','orange','green','grey'),bty = "n")





