
### MMRLandPL ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 5, by = 0.1) 			# time
x0=c(S = 0)							# initial conditions

parameters = c(
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

		dxdt = c(
			1		# this just mimics time. I do not understand this.
			)

		list(dy=c(dxdt),cont=NULL) # stating what should be in the output
		})
	}


output = ode(y = x0, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output
S = output[,2]

vmax = 1
km = 2
vmm = vmax * S / (km + S)
    
OP = 2
f = km / (km+OP)
gam = (vmax * OP /(km + OP)) * OP^(-f)
pl = gam * S ^ f


plot(t,vmm,type='l',col = 'blue',ylim=c(0,1)) 	# ploting vmm
lines(t,pl,col='orange')							# ploting pl
legend(x = 0,y = 1,legend = c('vmm','pl'),lty = c(1,1),col=c('blue','orange'),bty = "n")


