
### MonteCarloPops ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 50, by = 0.1) 			# time

parameters = c(
    		r1 = 0.2,
    		K1 = 50,
    		a = 0.2,
    		r2 = 0.4,
    		K2 = 25,
    		b = 0.25
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

		dxdt = c(
			r1 * (K1 - N1 - a * N2) * N1 / K1,		# dx1dt differential equation for x1
          		r2 * (K2 - N2 - b * N1) * N2 / K2		# dx2dt differential equation for x2
			)

		list(dy=c(dxdt),cont=NULL) # stating what should be in the output
		})
	}

n=10
initials = matrix(rep(0,2*n),ncol = 2)
finals = matrix(rep(0,2*n),ncol = 2)
outputs = list()
for (i in 1:n){
	initials[i,] = x0=c(N1 = 100 * runif(1,0,1), N2 = 50 * runif(1,0,1))
	output = ode(y = x0, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output
	finals[i,] = output[dim(output)[1],2:3]
	outputs[[i]] = output
	}

par(mfrow = c(2,1))
plot(outputs[[1]][,1:2],type='l',col = 'blue',ylim=c(0,max(1,100)),ylab='N1') 	# ploting N1
for (i in 2:n){lines(outputs[[i]][,c(1,2)],col='blue')}
plot(outputs[[1]][,c(1,3)],type='l',col = 'orange',ylim=c(0,max(1,50)),ylab='N2') 	# ploting N2
for (i in 2:n){lines(outputs[[i]][,c(1,3)],col='orange')}




