
### Pop1 ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 100, by = 0.1) 			# time
x0=c(N1 = 2, N2 = 50)				# initial conditions

parameters = c(
    		r1 = 0.2,
   	 	K1 = 50,
    		a = 0.2,
    		r2 = 0.4,
    		K2 = 25,
    		b = 0.25
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

		dxdt = c(
			r1 * (K1 - N1 - a * N2) * N1 / K1,		# dx1dt differential equation for N1
          		r2 * (K2 - N2 - b * N1) * N2 / K2		# dx2dt differential equation for N2
			)

		list(dy=c(dxdt),cont=NULL) # stating what should be in the output
		})
	}

output = ode(y = x0, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output


plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(1,output[,2:3])),ylab='') 	# ploting N1
lines(output[,c(1,3)],col='orange')							# ploting N2
legend(x = 80,y = 40,legend = c('N1','N2'),lty = c(1,1),col=c('blue','orange'),bty = "n")


