
### SIR ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 365, by = 0.1) 			# time
state = c(S = 990, I = 10, R = 0)				# initial conditions		
#state = c(S = 990, I = 10, R = 0, Q = 0)			# initial conditions	

parameters = c(
    		b = 3,
    		r = .01,
    		e = 0.0005*1,  	# 0.2
    		lam = .05,
    		d = .02,
    		q = .1*0   		# quarantine
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

		dxdt = c(
			b + r * R - e * S * I,					# dS/dt
          		e * S * I - lam * I - d * I - q * I,		# dI/dt
          		lam * I - r * R						# dR/dt
			)						

		list(dy=c(dxdt),cont=NULL) # stating what should be in the output
		})
	}

output = ode(y = state, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output

par(mfrow = c(2,1))
plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(1000,output[,2:4]))) 	# ploting S
lines(output[,c(1,3)],col='orange')								# ploting I
lines(output[,c(1,4)],col='green')								# ploting R
legend(x = 250,y = 1000,legend = c('S','I','R'),lty = c(1,1,1),col=c('blue','orange','green'),bty = "n")





### SIRQ ###

# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 365, by = 0.1) 			# time		
state = c(S = 990, I = 10, R = 0, Q = 0)			# initial conditions	

parameters = c(
    		b = 3,
    		r = .01,
    		e = 0.0005*1,
    		lam = .05,
    		d = .02,
    		q = .1   		# quarantine
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

		dxdt = c(
			b + r * R - e * S * I,					# dS/dt
          		e * S * I - lam * I - d * I - q * I,		# dI/dt
          		lam * I + lam * Q - r * R,				# dR/dt
			q * I	- lam * Q - d * Q					# dQ/dt
			)						

		list(dy=c(dxdt),cont=NULL) # stating what should be in the output
		})
	}

output = ode(y = state, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output

plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(1000,output[,2:4]))) 	# ploting S
lines(output[,c(1,3)],col='orange')								# ploting I
lines(output[,c(1,4)],col='green')								# ploting R
lines(output[,c(1,5)],col='red')								# ploting Q
legend(x = 250,y = 1000,legend = c('S','I','R','Q'),lty = c(1,1,1,1),col=c('blue','orange','green','red'),bty = "n")


