
### predatorPrey222 ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 1000, by = 0.1) 			# time
x0=c(prey = 10, pred = 1)				# initial conditions

parameters = c(
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

		Food = 0.1		# Food = 0
		Hunting = 0		# Hunting = 0.1

		dxdt = c(
			1.5 * prey - 0.2 * prey * pred - Hunting,		# dpreydt differential equation for prey
          		0.015 * prey * pred - 0.2 * pred + Food		# dpreddt differential equation for pred
			)

		list(dy=c(dxdt),cont=NULL) # stating what should be in the output
		})
	}

output = ode(y = x0, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output


plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(1,output[,2:3]))) 	# ploting prey
lines(output[,c(1,3)],col='orange')							# ploting pred
legend(x = 30,y = 150,legend = c('prey','pred'),lty = c(1,1),col=c('blue','orange'),bty = "n")



