
### purineSimple ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 2000, by = 0.1) 			# time
x0=c(P = 5, I = 400, G = 100, H = 10, X = 5, U = 100)				# initial conditions

parameters = c(
    		k1 = 320,
    		k2 = 0.5,
    		k3 = 0.3,
    		k4 = 1.2,
    		k5 = 2,
    		k6 = 12,
    		k7 = 0.01,
    		k8 = 0.1,
    		k9 = 0.75,
    		k10 = 0.004,
    		k11 = 1.4,
    		k12 = 0.031,
    		vIn = 5
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

    		vPG = k1 * P^1.2 * G^(-1.2)
    		vPI = k2 * P^2 * I^(-0.6)
    		vPH = k3 * P^0.5;				 
    		vPHI = k4 * P * I^(-0.5) * H^0.5

    		vIG = k5 * I^0.2 * G^(-0.2)
    		vGI = k6 * G^0.7 * I^(-1.2) 
    		vGX = k7 * G^0.5
	
    		vIH = k8 * I^0.8

    		vHX = k9 * H^0.6	
    		vHout = k10 * H;				

    		vXU = k11 * X^0.5	

    		vUout = k12 * U^1

		dxdt = c(
			vIn - vPG  - vPH  - vPI - vPHI,		# dPdt 
          		vPI + vPHI + vGI - vIG - vIH,			# dIdt
          		vPG + vIG - vGI - vGX,				# dGdt
          		vPH + vIH - vPHI - vHX - vHout,		# dHdt
          		vGX + vHX - vXU,					# dXdt
          		vXU - vUout						# dUdt
			)

		list(dy=c(dxdt),cont=NULL) # stating what should be in the output
		})
	}

output = ode(y = x0, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output


plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(1,output[,2:7]))) 	# ploting P
lines(output[,c(1,3)],col='orange')							# ploting I
lines(output[,c(1,4)],col='green')							# ploting G
lines(output[,c(1,5)],col='cyan')							# ploting H
lines(output[,c(1,6)],col='grey')							# ploting X
lines(output[,c(1,7)],col='black')							# ploting U
legend(x = 1500,y = 300,legend = c('P','I','G','H','X','Y'),lty = c(1,1),col=c('blue','orange','green','cyan','grey','black'),bty = "n")



