
### Reverse ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 20, by = 0.1) 			# time
state=c(X1 = 2, X2 = 4, X3 = 3, X4 = 0.5)				# initial conditions

parameters = c(
    		x0 = 1,
		a1 = 5,
    		b1 = .6,
    		b2 = 1.2,
    		b3 = 0.8,
    		b4 = 2,
    		c1 = 3,
    		r1 = 0,
    		r2 = 0,
    		g = -0.1,
    		h = .5
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

		dxdt = c(
			a1 * x0 * X3^g - b1 * X1 - c1 * X1^.5 + r1 * X2^.5, 		# dX1/dt
          		b1 * X1 - b2 * X2^.4 - r1 * X2^.5 + r2 * X3^.5,			# dX2/dt
          		b2 * X2^.4 - b3 * X3^h - r2 * X3^.5,				# dX3/dt
          		c1 * X1^.5 - b4 * X4^.8							# dX4/dt
			)						

		list(dy=c(dxdt),cont=NULL) # stating what should be in the output
		})
	}

output = ode(y = state, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output

plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(1,output[,2:5]))) 	# ploting X1
lines(output[,c(1,3)],col='orange')							# ploting X2
lines(output[,c(1,4)],col='green')							# ploting X3
lines(output[,c(1,5)],col='red')							# ploting X4
legend(x = 15,y = 4,legend = c('X1','X2','X3','X4'),lty = c(1,1),col=c('blue','orange','green','red'),bty = "n")


