
### simplifiedMAPK ###

# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 10, by = 0.1) 									# time
state=c(X1 = 9, X1P = 1, X2 = 9, X2P = 1, X3 = 9, X3P = 1)				# initial conditions

parameters = c(
   		a1 = 10,
    		b1 = .1,
    		a2 = 10,
    		b2 = 4,
    		a3 = 10,
    		b3 = 4
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

    		S = 1
    		if (t > 4) {S = 200}
    		if (t > 8) {S = 1} 	  

		dXdt = c(
			a1 * X1P - b1 * X1 * S,			# dX1/dt
          		b1 * X1 * S - a1 * X1P,			# dX1P/dt
          		a2 * X2P - b2 * X2 * X1P,		# dX2/dt
          		b2 * X2 * X1P - a2 * X2P,		# dX2P/dt
          		a3 * X3P - b3 * X3 * X2P,		# dX3/dt
          		b3 * X3 * X2P - a3 * X3P		# dX3P/dt
			)

		list(dy=c(dXdt),cont=NULL) # stating what should be in the output
		})
	}	

output = ode(y = state, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output

plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(15,output[,2:7])))  # ploting X1
lines(output[,c(1,3)],col='orange')		# ploting X1P
lines(output[,c(1,4)],col='green')		# ploting X2
lines(output[,c(1,5)],col='red')		# ploting X2P
lines(output[,c(1,6)],col='purple')		# ploting X3
lines(output[,c(1,7)],col='brown')		# ploting X3P
legend(4.5,15,legend=c("X1","X1P","X2","X2P","X3","X3P"),lty=c(1,1,1,1,1,1),col=c("blue","orange","green","red","purple","brown"),bty = "n")








