
### Stability HW ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 20, by = 0.1) 			# time
state=c(P1 = 0.3, P2 = 0.3)				# initial conditions

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state)),
		{

		dxdt = c(
			2 * P1^(-1) * P2^(-2) - 2 * P1^2 * P2^4,	# dP1/dt
          		4 * P1^2 * P2 - 4					# dP2/dt
			)						

		list(dy=c(dxdt),cont=NULL) # stating what should be in the output
		})
	}

output = ode(y = state, times = t, func = equations)	# calling the ODE solver and producing the output

plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(1,output[,2:3]))) 	# ploting P1
lines(output[,c(1,3)],col='orange')							# ploting P2
legend(x = 15,y = 3,legend = c('P1','P2'),lty = c(1,1),col=c('blue','orange'),bty = "n")

