
### twoComp ###

# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 48, by = 0.1) 									# time
state=c(B = 0, L = 0)				# initial conditions

parameters = c(
    		k0B = 0, 
    		kLB = .5,
    		kB0 = .9,
    		kBL = .8,
    		kL0 = .3
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{
		
    		IN = 0
    		if (t > 8) {IN = 10}
    		if (t > 8.4) {IN = 0} 	 # t > 8.1 

		dXdt = c(
			k0B + kLB * L - (kB0 + kBL) * B + IN, 		# dB/dt
         	 	kBL * B - (kL0+ kLB) * L				# dL/dt
			)

		list(dy=c(dXdt),cont=NULL) # stating what should be in the output
		})
	}	

output = ode(y = state, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output

plot(output[,1:2],type='l',col = 'blue',ylim=c(0,max(1,output[,2:3])))  	# ploting B
lines(output[,c(1,3)],col='orange')								# ploting L
legend(30,0.8,legend=c("B","L"),lty=c(1,1),col=c("blue","orange"),bty = "n")








