
### VectorfieldPops ###


# lsoda automatically switches between the Adams' method and the BDF (backward differentiation formula) method.
# daspk Differential Algebraic Equations solver using a combination of backward differentiation formula (BDF) and a direct linear system solution method (dense or banded).

rm(list=ls())	#clean memory
graphics.off() 	#close plot windows

library(deSolve)	#library for solve diferential equations

t=seq(from = 0, to = 0.5, by = 0.5) 			# time
state=c(N1 = 2, N2 = 4)				# initial conditions

parameters = c(
    		r1 = 0.2,
    		K1 = 50,
    		a = 0.2,
    		r2 = 0.4,
    		K2 = 25,
    		b = 0.25
		)

equations=function(t,state,parameters) 	# function containing the diferential equations
	{with(as.list(c(state,parameters)),
		{

		dxdt = c(
			r1 * (K1 - N1 - a * N2) * N1 / K1, 		# dN1/dt
          		r2 * (K2 - N2 - b * N1) * N2 / K2		# dN2/dt
			)						

		list(dy=c(dxdt),cont=NULL) # stating what should be in the output
		})
	}

initials_finals = matrix(rep(NA,20*20*5),ncol=5)
colnames(initials_finals) = c('N1 initial','N2 initial','    ','N1 final','N2 final')
plot(0,0,col= 'white',xlim=c(0,100),ylim=c(0,50),xlab='N1',ylab='N2')
for (i in 1:20)
	{
	for (j in 1:20)
		{
		initials_finals[i+(j-1)*20,1:2] = state=c(N1 = 5 * i, N2 = 2.5 * j)								# initial conditions
		output = ode(y = state, times = t, func = equations, parms = parameters)	# calling the ODE solver and producing the output
		initials_finals[i+(j-1)*20,4:5] = output[2,2:3]
		arrows(x0 = output[1,2], y0 = output[1,3], x1 = output[2,2], y1 = output[2,3],length = 0.05,col='blue')
		}
	}

initials_finals


