function [] = Branch_pathway_MCS()
    clc

    t0 = 0;
    tf = 20;
    X0 = 1;
    a1 = 5;
    b1 = .2;
    b2 = 2;
    b3 = 2;
    b4 = 2;
    c1 = 3;
    c2 = 0.5;
    c3 = 0.5;
    n = 3;
    g = 2 * rand(n ^ 2,1) - 2;
    h = 4 * rand(n ^ 2,1);
    x0 = [2, 4, 6, 0.5, 0.1, 0.1];
    figure
    for i = 1 : n ^ 2
        [t,X] = ode45(@(t,x)branchPathway(t,x,X0,a1,b1,b2,b3,b4,c1,c2,c3,g(i),h(i)),(t0: 0.2 : tf),x0);       
        subplot(n,n,i);plot(t,X);
        legend('X1','X2','X3','X4','X5','X6');
        title(sprintf('g = %.4f , h = %.4f',g(i),h(i)));
    end
end
function dx = branchPathway(t,x,X0,a1,b1,b2,b3,b4,c1,c2,c3,g,h)
    dx = [a1 * X0 * x(4) ^ g - b1 * x(1) - c1 * x(1) ^ 2 * x(4) ^ h
          b1 * x(1) - b2 * x(2) ^ 0.4
          b2 * x(2) ^ 0.4 - b3 * x(3) ^ 0.7
          b3 * x(3) ^ 0.7 - b4 * x(4) ^ 0.8
          c1 * x(1) ^ 2 * x(4) ^ h - c2 * x(5)
          c2 * x(5) - c3 * x(6)];
end