function [] = CFmodel()
    t0 = 0;
    tf = 400;
    B0 = 1278.037;
    P0 = 64.7532;
    A0 = 15.04461;
    H0 = 1713.089;
    D0 = 100;
    M0 = 12.75542;
    x0 = [B0, P0, A0, H0, D0, M0]';
    CF = 1;
    global doseB
    doseB = [20 160 300
            3000 5000 10000];
    [r,c] = size(doseB);
    T = double.empty;
    X = double.empty;
    options = odeset('Events',@(t, x) events(t,x));
    for i = 1 : c + 1
        options = odeset('Events',@(t,x) events(t,x,i));
        [t,x] = ode45(@(t,x)CF_model(t,x,CF),(t0: 1 : tf),x0,options);
        x0 = x(end,:);
        if i <= c x0(1) = doseB(2,i); end
        t0 = t(end);
        T = [T;t];
        X = [X;x];
        clear x t        
    end
    plot(T,X);hold on
    legend('B','P','A','H','D','M');
    H = X(:,4);
    D = X(:,5);
    LF = 100 * ((H ./ D)/(H0 / D0));
    PH = 100 * H / H0;
    
end
function dx = CF_model(t,x,CF)
    AB = 0;
    if t > 22 AB = 5; end
    if t > 32 AB = 0; end   
    if t > 162 AB = 5; end
    if t > 172 AB = 0; end    
    if t > 302 AB = 5; end
    if t > 312 AB = 0; end
    
    dx = [(x(1)^0.8 * x(6)^1.2 - 0.8 * x(1)^1.2 * x(2)^.1 * (AB + 1)) * x(6)^-2.4;	
          20 * x(1)^0.2 * x(5)^0.4 * x(3)^-0.1 - 50 * x(2)^0.5;	
          15 * x(1)^0.1 * x(2)^0.1 - 12 * x(3)^0.5;
          500 - 40 * x(4)^0.3 * x(2)^0.2 * x(3)^-0.2;	
          40 * x(4)^0.3 * x(2)^0.2 * x(3)^-0.2 - 5 * x(5);
          0.16 * x(1)^0.25 * 2^CF - 0.15 * x(6)^(2-1*CF)];
end
function [value,isterminal,direction] = events(t,x,i)
    global doseB
    value = [doseB(1,1) - t; doseB(1,2) - t; doseB(1,3) - t];
    isterminal = [1; 1; 1];
    direction = [0; 0; 0];
end