function [] = MMRL()
    clc

    Etot = 4;
    k1 = 1;
    k1r = 0.3;
    k2 = 1.5;
    
%           S C P SS
    x0 = [100 0 0 0];
    
    t0 = 0;
    tf = 20;
    
    [t,x] = ode45(@(t,x)mmrl(t,x,Etot,k1,k1r,k2),(t0: 0.1 : tf),x0); 

    SS = x(:,4);
    Vmax = k2 * Etot;
    KM = (k1r + k2) / k1;
    v = Vmax * SS ./ (KM + SS);
    Pdot = k2 * x(:,2);
    
    plot(t,x(:,1),t,v,t,x(:,4),t,Pdot);
    legend('S','v','SS','Pdot');
end
function dx = mmrl(t,x,Etot,k1,k1r,k2)    
    E = Etot - x(2);
    dx = [- k1 * x(1) * E + k1r * x(2);
          k1 * x(1) * E - (k1r + k2) * x(2);
          k2 * x(2);
          5];
end