function [] = FermetationSystem()
    clc

    mu_max = 5;
    K1 = 2;
    K2 = 10;

    a = 0.01;
    b = 0.05;
    c = 0.03;

    G = 2;
    
%          B  E
    x0 = [36 60];
    
    t0 = 0
    tf = 500
    
    [t,x] = ode45(@(t,x)fermentaion(t,x,mu_max,K1,K2,G,a,b,c),(t0: 20 : tf),x0); 
    
    plot(t,x);
    legend('B','E');
end
function dx = fermentaion(t,x,mu_max,K1,K2,G,a,b,c)  
    if t > 100 G =4; end
    if t > 300 G = 2; end
    dx = [mu_max * x(1) * (G / (K1 + G)) * K2 / (K2 + x(2)) - a * x(1)^2;
          b * x(1) - c * x(2)];
end

