function [] = Linearization()
    clc

    c1 = 3;
    c2 = 2;
    c3 = 5;
    c4 = 6;
    c5 = 3;
    n = 2;
    
%         X        Y XX YY
    x0 = [8.660143 2 0 0];
    
    t0 = 0;
    tf = 50;
    options = odeset('MaxStep',1);
    [t,x] = ode45(@(t,x)linear(t,x,c1,c2,c3,c4,c5,n,x0),(t0: 0.1 : tf),x0,options); 
    XXX = x(:,3) + 8.660143;
    YYY = x(:,4) + 2;
    plot(t,x(:,1),t,x(:,2),t,XXX,t,YYY);
    legend('X','Y','XXX','YYY');
    ylim([0 15]);
end
function dx = linear(t,x,c1,c2,c3,c4,c5,n,x0)
    Bolus = 0;
    if t > 5 Bolus = 5; end
    if t > 6 Bolus = 0; end
    dx = [c1 - c2 * x(2) * x(1)^n / (c3^n + x(1)^n) + Bolus;
          c4 - c5 * x(2);
          -(c2 * x0(2) * 2 * c3^2 * x0(1) / (c3^2 + x0(1)^2)^2) * x(3) - (c2 * x0(1)^2 / (c3^2 + x0(1)^2)) * x(4) + Bolus;
          - c5 * x(4)];
end

