function [] = LotkaChaos()
    clc
   
    x0 = [1 1 1 1];
    
    t0 = 0;
    tf = 300;
    
    options = odeset('MaxStep',1);
    [t,x] = ode45(@(t,x)lotka(t,x),(t0: 0.1 : tf),x0,options);

    plot(t,x);
    legend('x1','x2','x3','x4');
    
end
function dx = lotka(t,x)
    r1 = 1;
    r2 = 0.72;
    r3 = 1.53;
    r4 = 1.27;

    a11 = 1;
    a12 = 1.09;
    a13 = 1.52;
    a14 = 0;
    a21 = 0;
    a22 = 1;
    a23 = 0.44;
    a24 = 1.36;
    a31 = 2.33;
    a32 = 0;
    a33 = 1;
    a34 = 0.47;
    a41 = 1.21;
    a42 = 0.51;
    a43 = 0.35;
    a44 = 1;
    
    dx = [r1 * x(1) * (1 - a11 * x(1) - a12 * x(2) - a13 * x(3) - a14 * x(4))
          r2 * x(2) * (1 - a21 * x(1) - a22 * x(2) - a23 * x(3) - a24 * x(4))
          r3 * x(3) * (1 - a31 * x(1) - a32 * x(2) - a33 * x(3) - a34 * x(4))
          r4 * x(4) * (1 - a41 * x(1) - a42 * x(2) - a43 * x(3) - a44 * x(4))];
end

