function [] = MMRLandPL()
    clc
   
    S0 = 0;
    
    t0 = 0;
    tf = 5;
    
    options = odeset('MaxStep',1);
    [t,S] = ode45(@(t,x)mmrlPl(t,x),(t0: 0.1 : tf),S0,options);

    vmax = 1;
    km = 2;
    vmm = vmax * S ./ (km + S);
    
    OP = 2;
    f = km / (km+OP);
    gam = (vmax * OP /(km + OP)) * OP^(-f);
    pl = gam * S .^ f;
    
%     gam = 2
%     f = 0.5
    
    plot(t,vmm,t,pl);
    legend('vmm','pl');
    
end
function dS = mmrlPl(t,S)
    dS = 1;
end

