function [] = Pop1()
    clc
    
    t0 = 0;
    tf = 100;
    N0 = [2 50];
    [t,N] = ode45(@(t,N)pop1(t,N),(t0: 1 : tf),N0);
    plot(t,N(:,1),'r',t,N(:,2),'b');
    legend('N1','N2');
end
function dN = pop1(t,N)
    r1 = 0.2;
    K1 = 50;
    a = 0.2;

    r2 = 0.4;
    K2 = 25;
    b = 0.25;

    dN = [r1 * (K1 - N(1) - a * N(2)) * N(1) / K1
          r2 * (K2 - N(2) - b * N(1)) * N(2) / K2];
end