function [] = SIRS()
    clc
    
    t0 = 0;
    tf = 365;
    x0 = [990 10 0];
%     x0 = [990 10 0 0];    
    [t,x] = ode45(@(t,x)sirs(t,x),(t0: 1 : tf),x0);
    plot(t,x);
    legend('S','I','R');
%     legend('S','I','R','Q');
end
function dx = sirs(t,x)

    b = 3;
    r = .01;
    e = 0.0005*1;  %0.2
    lam = .05;
    d = .02;

    q = .1*0; %quarantine

    dx = [b + r * x(3) - e * x(1) * x(2)
          e * x(1) * x(2) - lam * x(2) - d * x(2) - q * x(2)
          lam * x(2) - r * x(3)];
%           q * x(2)];
end