function [] = SimplifiedMAPK()
    clc
    
    t0 = 0;
    tf = 10;
    X0 = [9 1 9 1 9 1];
    event = 1;
    S = 1;
    options = odeset('Events',@(t,X) events(t,X));
    t = double.empty;
    x = double.empty;
    while event ~=0
        [T,X] = ode45(@(T,X)MAPK(T,X,S),(t0: 0.1 : tf),X0,options);
        if T(end) == 4 
            S = 200;
            X0 = X(end,:);
            t0 = T(end);
            t = [t;T];
            x = [x;X];
            clear X T
        elseif T(end) == 8 
            S = 1;
            X0 = X(end,:);
            t0 = T(end);
            t = [t;T];
            x = [x;X];
            clear X T
        elseif T(end) == tf
            event = 0;
            t = [t;T];
            x = [x;X];
            clear X T
        end
    end
    plot(t,x);
    legend('X1','X1P','X2','X2P','X3','X3P');
end
function dX = MAPK(T,X,S)

    a1 = 10;
    b1 = .1;

    a2 = 10;
    b2 = 4;

    a3 = 10;
    b3 = 4;

    dX = [a1 * X(2) - b1 * X(1) * S
          b1 * X(1) * S - a1 * X(2)
          a2 * X(4) - b2 * X(3) * X(2)
          b2 * X(3) * X(2) - a2 * X(4)
          a3 * X(6) - b3 * X(5) * X(4)
          b3 * X(5) * X(4) - a3 * X(6)];
end
function [value,isterminal,direction] = events(T,X)
    value = [4 - T; 8 - T];
    isterminal = [1; 1];
    direction = [0; 0];
end