function [] = TwoComp()
    clc
    
    t0 = 0;
    tf = 48;
    X0 = [0 0];
    event = 1;
    IN = 0;
    options = odeset('Events',@(t,X) events(t,X));
    t = double.empty;
    x = double.empty;
    while event ~=0
        [T,X] = ode45(@(T,X)twoComp(T,X,IN),(t0: 0.1 : tf),X0,options);
        if T(end) == 8 
            IN = 10;
            X0 = X(end,:);
            t0 = T(end);
            t = [t;T];
            x = [x;X];
            clear X T
        elseif T(end) == 8.1 
            IN = 0;
            X0 = X(end,:);
            t0 = T(end);
            t = [t;T];
            x = [x;X];
            clear X T
        elseif T(end) == tf
            event = 0;
            t = [t;T];
            x = [x;X];
            clear X T
        end
    end
    plot(t,x);
    legend('B','L');
end
function dX = twoComp(T,X,IN)

    k0B = 0; 
    kLB = .5;
    kB0 = .9;
    kBL = .8;
    kL0 = .3;
    
    dX = [k0B + kLB * X(2) - (kB0 + kBL) * X(1) + IN
          kBL * X(1) - (kL0+ kLB) * X(2)];
end
function [value,isterminal,direction] = events(T,X)
    value = [8 - T; 8.1 - T];
    isterminal = [1; 1];
    direction = [0; 0];
end