function [] = VectorfieldPops()
    clc
    
    t0 = 0;
    tf = 0.5;
    
    initials = double.empty;
    finals = double.empty;
    for i = 1 : 20
        for j = 1 : 20
            N0 = [5 * i,2.5 * j];
            [t,N] = ode45(@(t,N)vectorfield(t,N),(t0: 0.5 : tf),N0);
            plot(t,N(:,1),'r',t,N(:,2),'b');hold on
            initials = [initials;N0]; 
            finals = [finals;N(end,:)];
        end
    end
    display('   N1 initial N2 initial N1 final N2 final');
    [initials finals]
    legend('N1','N2');
    
end
function dN = vectorfield(t,N)
    r1 = 0.2;
    K1 = 50;
    a = 0.2;

    r2 = 0.4;
    K2 = 25;
    b = 0.25;
    
    dN = [r1 * (K1 - N(1) - a * N(2)) * N(1) / K1;
          r2 * (K2 - N(2) - b * N(1)) * N(2) / K2];

end