function [] = limitCycleSystem()
    clc

    a1 = 0.9;
    h = 0.2;
    
    x0 = [1.036661 1.197246];
    
    t0 = 0;
    tf = 60;
    
    event = 1;
    T = double.empty;
    X = double.empty;
    options = odeset('MaxStep',1,'Events',@(t, x) events(t,x));
    
    while event ~= 0
        [t,x] = ode45(@(t,x)limitCycle(t,x,a1,h),(t0: 1 : tf),x0,options);
        if t(end) == tf
            event = 0;
            X = [X;x];
            T = [T;t];
        else
            x0 = x(end,:);
            x0(1) = 1.2;
            t0 = t(end);
            X = [X;x];
            T = [T;t];
            clear x t
        end
    end

    plot(T,X);
    legend('X1','X2');
    
end
function dx = limitCycle(t,x,a1,h)
    dx = [a1 * x(1)^0.4 * x(2)^-0.15 - x(1)^h;
          x(1) - x(2)^0.2];
end
function [value,isterminal,direction] = events(t,x)
    value = 10 - t;
    isterminal = 1;
    direction = 0;
end
