function [] = purineSimple()
    clc
    
    t0 = 0;
    tf = 2000;
    x0 = [5 400 100 10 5 100];
    [t,x] = ode45(@(t,x)purine(t,x),(t0: 1 : tf),x0);
    plot(t,x);
    legend('P','I','G','H','X','U');
end
function dx = purine(t,x)

    k1 = 320;
    k2 = 0.5;
    k3 = 0.3;
    k4 = 1.2;
    k5 = 2;
    k6 = 12;
    k7 = 0.01;
    k8 = 0.1;
    k9 = 0.75;
    k10 = 0.004;
    k11 = 1.4;
    k12 = 0.031;
    
    vIn = 5;

    vPG = k1 * x(1)^1.2 * x(3)^-1.2;  
    vPI = k2 * x(1)^2 * x(2)^-0.6; 	
    vPH = k3 * x(1)^0.5;				 
    vPHI = k4 * x(1) * x(2)^-0.5 * x(4)^0.5;  

    vIG = k5 * x(2)^0.2 * x(3)^-0.2; 
    vGI = k6 * x(3)^0.7 * x(2)^-1.2;     
    vGX = k7 * x(3)^0.5;		

    vIH = k8 * x(2)^0.8; 		

    vHX = k9 * x(4)^0.6;			
    vHout = k10 * x(4);				

    vXU = k11 * x(5)^0.5;			

    vUout = k12 * x(6)^1;

    dx = [vIn - vPG  - vPH  - vPI - vPHI 
          vPI + vPHI + vGI - vIG - vIH
          vPG + vIG - vGI - vGX
          vPH + vIH - vPHI - vHX - vHout
          vGX + vHX - vXU
          vXU - vUout];
end